import {AsyncPipe} from "@angular/common";
import {
  Pipe,
  PipeTransform,
} from "@angular/core";
import {
  ObservableOrPromiseOrValue,
  observablify,
} from "@shared/models/extra-button-toolbar.model";
import {
  map,
  tap,
} from "rxjs/operators";
import {isEquality} from "solidify-frontend";

@Pipe({
  name: "solidifyAsync",
})
export class SolidifyAsyncPipe extends AsyncPipe implements PipeTransform {

  private _source: ObservableOrPromiseOrValue<any> | null | undefined;

  private _latestResult: any | null | undefined;

  private _gotValue: boolean = false;

  transform<T>(source: ObservableOrPromiseOrValue<T> | null | undefined,
               options?: SolidifyAsyncPipeOptions | null | undefined): T | null | undefined {
    const safeOptions = {
      ...this.getDefaultSolidifyAsyncPipeOptions(),
      ...options,
    };
    if (this._source !== source) {
      this._source = source;
      this._gotValue = false;
      this._latestResult = super.transform(observablify(source).pipe(
        map(value => safeOptions.preventFallbackValueConflict && isEquality(value, safeOptions.fallbackValue) ?
          SolidifyAsyncPipe._invertFallbackValue(value as null | undefined) : value),
        tap(() => this._gotValue = true)),
      );
    }
    if (!this._gotValue) {
      this._latestResult = safeOptions.fallbackValue;
    }
    return this._latestResult;
  }

  getDefaultSolidifyAsyncPipeOptions(): SolidifyAsyncPipeOptions {
    return {
      fallbackValue: null,
      preventFallbackValueConflict: true,
    };
  }

  private static _invertFallbackValue(value: null | undefined): null | undefined {
    return value === null ? undefined : null;
  }

}

export interface SolidifyAsyncPipeOptions {
  fallbackValue?: null | undefined;
  preventFallbackValueConflict?: boolean;
}
