import {
  Pipe,
  PipeTransform,
} from "@angular/core";
import {SharedAbstractPipe} from "@app/shared/pipes/shared-abstract/shared-abstract.pipe";
import {FileUtil} from "@shared/utils/file.util";

@Pipe({
  name: "filesize",
})
export class FileSizePipe extends SharedAbstractPipe implements PipeTransform {
  transform(size: number): string {
    return FileUtil.transformFileSize(size);
  }
}
