import {
  Pipe,
  PipeTransform,
} from "@angular/core";
import {SharedAbstractPipe} from "@app/shared/pipes/shared-abstract/shared-abstract.pipe";
import {DateUtil} from "solidify-frontend";

@Pipe({
  name: "datetime",
})
export class DatetimePipe extends SharedAbstractPipe implements PipeTransform {
  transform(date: Date): string {
    return DateUtil.convertDateToDateTimeString(date);
  }
}
