import {
  Pipe,
  PipeTransform,
} from "@angular/core";
import {SharedAbstractPipe} from "@app/shared/pipes/shared-abstract/shared-abstract.pipe";
import {
  isArray,
  ObjectUtil,
} from "solidify-frontend";

@Pipe({
  name: "clone",
})
export class ClonePipe<T> extends SharedAbstractPipe implements PipeTransform {
  transform(object: T | T[]): T | T[] {
    if (isArray(object)) {
      return [...object];
    }
    return ObjectUtil.clone(object);
  }
}
