import {ElementRef} from "@angular/core";
import {Navigate} from "@ngxs/router-plugin";
import {MatButtonThemeClassName} from "@shared/directives/shared-mat-button-theme/shared-mat-button-theme.directive";
import {DataTestEnum} from "@shared/enums/data-test.enum";
import {IconNameEnum} from "@shared/enums/icon-name.enum";
import {
  EMPTY,
  Observable,
  of,
} from "rxjs";
import {fromPromise} from "rxjs/internal-compatibility";
import {
  BaseResource,
  isNull,
  isObservable,
  isPromise,
  isUndefined,
} from "solidify-frontend";

export interface ExtraButtonToolbar<TResourceModel extends BaseResource> {
  color: "accent" | "primary" | "warn" | "success";
  class?: string | undefined;
  icon: IconNameEnum;
  typeButton?: MatButtonThemeClassName;
  labelToTranslate: (current?: TResourceModel | undefined) => ObservableOrPromiseOrValue<string>;
  tooltipToTranslate?: string | undefined;
  navigate?: Navigate;
  callback?: (current?: TResourceModel | undefined, buttonElementRef?: ElementRef | undefined, checked?: boolean) => void;
  order?: number;
  dataTest?: DataTestEnum;
  displayCondition?: (current?: TResourceModel | undefined) => ObservableOrPromiseOrValue<boolean>;
  disableCondition?: (current?: TResourceModel | undefined) => ObservableOrPromiseOrValue<boolean>;
  isToggleButton?: boolean;
  isToggleChecked?: boolean;
}

export type ObservableOrPromiseOrValue<T> = Observable<T> | Promise<T> | T;

export function observablify<T>(source: ObservableOrPromiseOrValue<T>, emptyOnUndefined?: boolean, emptyOnNull?: boolean): Observable<T> {
  return isObservable(source) ? source
    : isPromise(source) ? fromPromise(source)
      : emptyOnUndefined && isUndefined(source) ? EMPTY
        : emptyOnNull && isNull(source) ? EMPTY
          : of(source);
}
