import {Type} from "@angular/core";
import {
  Data,
  LoadChildren,
  Params,
  ResolveData,
  Route,
  Routes,
  RunGuardsAndResolvers,
  UrlMatcher,
} from "@angular/router";
import {ApplicationRolePermissionEnum} from "@app/shared/enums/application-role-permission.enum";
import {Enums} from "@enums";
import {BaseResourceState} from "solidify-frontend";

export declare type DlcmRoutes = DlcmRoute[];

export class DlcmRoute implements Route {
  canActivate?: any[];
  canActivateChild?: any[];
  canDeactivate?: any[];
  canLoad?: any[];
  children?: Routes;
  component?: Type<any>;
  data?: DlcmData | undefined;
  loadChildren?: LoadChildren;
  matcher?: UrlMatcher;
  outlet?: string;
  path?: string;
  pathMatch?: string;
  redirectTo?: string;
  resolve?: ResolveData;
  runGuardsAndResolvers?: RunGuardsAndResolvers;
}

export class DlcmData implements Data {
  breadcrumb?: string | ((params: Params) => string);
  breadcrumbMemoizedSelector?: (state: BaseResourceState) => string;
  permission?: ApplicationRolePermissionEnum;
  orgUnitPermissionNeed?: Enums.Role.RoleEnum[];
  noBreadcrumbLink?: boolean;
}
