import {FieldTypeEnum} from "@app/shared/enums/field-type.enum";
import {DataTableComponentEnum} from "@shared/enums/data-table-component.enum";
import {DataTestEnum} from "@shared/enums/data-test.enum";
import {
  BaseResourceType,
  KeyValue,
  MappingObject,
  OrderEnum,
  ResourceNameSpace,
  ResourceState,
  Sort,
} from "solidify-frontend";

export interface DataTableColumns<TResource extends BaseResourceType = any> {
  field: string; // keyof TResource
  header: string;
  tooltip?: (value: string) => string | undefined;
  type?: FieldTypeEnum;
  order: OrderEnum;
  filterEnum?: KeyValue[];
  dataTest?: DataTestEnum;
  isMultipleFilterEnum?: boolean;
  translate?: boolean;
  isSortable?: boolean;
  isFilterable?: boolean;
  searchableSingleSelectSort?: Sort;
  filterableField?: string; // keyof TResource
  sortableField?: string; // keyof TResource
  resourceNameSpace?: ResourceNameSpace;
  resourceLabelKey?: string;
  resourceLabelCallback?: (value: any) => string;
  resourceState?: ResourceState<any, any>;
  component?: DataTableComponentEnum;
  width?: string | undefined;
  minWidth?: string | undefined;
  maxWidth?: string | undefined;
  extraSearchQueryParam?: MappingObject | undefined;
  isUser?: boolean;
}
