import {IconNameEnum} from "@shared/enums/icon-name.enum";
import {ObservableOrPromiseOrValue} from "@shared/models/extra-button-toolbar.model";
import {BaseResource} from "solidify-frontend";

export interface DataTableActions<TResource extends BaseResource = any> {
  logo: IconNameEnum;
  callback: (current: TResource) => void;
  placeholder: (current: TResource) => ObservableOrPromiseOrValue<string>;
  displayOnCondition?: (current: TResource) => boolean | undefined;
  disableCondition?: (current: TResource) => ObservableOrPromiseOrValue<boolean> | undefined;
  isVisible?: boolean | undefined;
  isWrapped?: boolean;
  order?: number | undefined;
}
