import {Enums} from "@enums";
import {ChangeInfo} from "@models";
import {JobExecutionReport} from "@shared/models/business/job-execution-report.model";

export interface JobExecution {
  resId?: string;
  jobId?: string;
  runNumber?: number;
  status?: Enums.PreservationJob.ExecutionStatusEnum;
  statusMessage?: string;
  startDate?: Date;
  endDate?: Date;
  processedItems?: number;
  ignoredItems?: number;
  inErrorItems?: number;
  completionStatus?: number;
  totalItems?: number;
  creation?: ChangeInfo;
  lastUpdate?: ChangeInfo;
  executionReports?: JobExecutionReport[];
}
