import {Checksum} from "@deposit/models/checksum.model";
import {Enums} from "@enums";
import {
  AipChecksumCheck,
  AipFileFormat,
  ChangeInfo,
  MetadataType,
} from "@models";

export interface DataFile {
  resId?: string;
  creation?: ChangeInfo;
  lastUpdate?: ChangeInfo;
  sourceData?: string;
  status?: Enums.DataFile.StatusEnum;
  statusMessage?: string;
  virusCheck?: AipChecksumCheck;
  smartSize?: string;
  relativeLocation?: string;
  packageId?: string;
  initialPath?: string;
  finalData?: string;
  fileSize?: number;
  fileName?: string;
  fileFormat?: AipFileFormat;
  dataCategory?: Enums.DataFile.DataCategoryEnum;
  dataType?: Enums.DataFile.DataTypeEnum;
  metadataType?: MetadataType;
  complianceLevel?: string;
  checksums?: Checksum[];
  available?: boolean;
}
