export enum MetadataEnum {
  aipDispositionApproval = "aip-disposition-approval",
  aipOrganizationalUnit = "aip-organizational-unit",
  aipThumbnail = "aip-thumbnail",
  aipDataTag = "aip-data-tag",
  aipRetention = "aip-retention",
  aipRetentionEnd = "aip-retention-end",
  aipSize = "aip-size",
  aipFiles = "aip-file-number",
  dataciteXml = "datacite.xml",
  dlcmXml = "dlcm.xml",
  aipContainer = "aip-container",

  /* PRIVATE */
  premis = "premis",
  premisComplexType = "premisComplexType",

  premisAgent = "premis:agent",
  premisAgentIdentifier = "premis:agentIdentifier",
  premisAgentIdentifierType = "premis:agentIdentifierType",
  premisAgentIdentifierValue = "premis:agentIdentifierValue",
  premisAgentType = "premis:agentType",
  premisAgentVersion = "premis:agentVersion",

  premisEvent = "premis:event",
  premisEventDateTime = "premis:eventDateTime",
  premisEventIdentifier = "premis:eventIdentifier",
  premisEventIdentifierType = "premis:eventIdentifierType",
  premisEventIdentifierValue = "premis:eventIdentifierValue",
  premisEventType = "premis:eventType",
  premisLinkingObjectIdentifier = "premis:LinkingObjectIdentifier",
  premisLinkingObjectIdentifierType = "premis:LinkingObjectIdentifierType",
  premisLinkingObjectIdentifierValue = "premis:LinkingObjectIdentifierValue",

  premisObject = "premis:object",
  premisOriginalName = "premis:originalMail",
  premisObjectIdentifier = "premis:objectIdentifier",
  premisObjectIdentifierType = "premis:objectIdentifierType",
  premisObjectIdentifierValue = "premis:objectIdentifierValue",

  version = "version",

  /* PUBLIC */
  dataciteResource = "datacite:resource",
  datacite = "datacite",
  xmlnsDatacite = "xmlns:datacite",
  dataciteDates = "datacite:dates",
  dataciteDate = "datacite:date",
  dataciteTitles = "datacite:titles",
  dataciteTitle = "datacite:title",
  dataciteResourceType = "datacite:resourceType",
  resourceTypeGeneral = "resourceTypeGeneral",
  content = "content",
  dataciteRelatedIdentifiers = "datacite:relatedIdentifiers",
  dataciteRelatedIdentifier = "datacite:relatedIdentifier",
  relationType = "relationType",
  relatedIdentifierType = "relatedIdentifierType",
  xmlnsDlcm = "xmlns:dlcm",
  xmlnsMets = "xmlns:mets",
  dataciteFormats = "datacite:formats",
  dataciteFormat = "datacite:format",
  dataciteIdentifier = "datacite:identifier",
  identifierType = "identifierType",
  dataciteRightsList = "datacite:rightsList",
  dataciteRights = "datacite:rights",
  rightsURI = "rightsURI",
  xmlnsXlink = "xmlns:xlink",
  datacitePublicationYear = "datacite:publicationYear",
  datacitePublisher = "datacite:publisher",
  dataciteDescriptions = "datacite:descriptions",
  dataciteDescription = "datacite:description",
  descriptionType = "descriptionType",
  dataciteCreators = "datacite:creators",
  dataciteCreator = "datacite:creator",
  dataciteCreatorName = "datacite:creatorName",
  xmlnsFits = "xmlns:fits",
  xmlnsPremis = "xmlns:premis",
  aipUnit = "aip-unit",
  creation = "creation",
  dateType = "dateType",
  rightsUtiForAccessLevelFinal = "https://www.dlcm.ch/access-level/final",
  rightsUtiForAccessLevel = "https://www.dlcm.ch",
}

export namespace ArchiveMetadata {

  export abstract class Metadata {
    [MetadataEnum.aipContainer]: string;
    [MetadataEnum.aipDispositionApproval]: string;
    [MetadataEnum.aipOrganizationalUnit]: string;
    [MetadataEnum.aipRetention]: string;
    [MetadataEnum.aipRetentionEnd]: string;
    [MetadataEnum.aipUnit]: string;
    [MetadataEnum.aipSize]: number;
    [MetadataEnum.aipFiles]: number;
    [MetadataEnum.creation]: string;
  }

  export interface PublicMetadata extends Metadata {
    [MetadataEnum.datacite]: Datacite;
    [MetadataEnum.dataciteXml]: string;
  }

  export interface PrivateMetadata extends Metadata {
    [MetadataEnum.premis]: Premis;
    [MetadataEnum.dlcmXml]: string;
  }

  /* PRIVATE */
  export interface Premis {
    [MetadataEnum.premisComplexType]: PremisComplexType;
  }

  export interface PremisComplexType {
    [MetadataEnum.premisAgent]: PremisAgent[];
    [MetadataEnum.premisEvent]: PremisEvent[];
    [MetadataEnum.premisObject]: PremisObject[];
    [MetadataEnum.version]: number;
  }

  export interface PremisAgent {
    [MetadataEnum.premisAgentIdentifier]: PremisAgentIdentifier;
    [MetadataEnum.premisAgentType]: string;
    [MetadataEnum.premisAgentVersion]: string;
  }

  export interface PremisAgentIdentifier {
    [MetadataEnum.premisAgentIdentifierType]: string;
    [MetadataEnum.premisAgentIdentifierValue]: string;
  }

  export interface PremisEvent {
    [MetadataEnum.premisEventIdentifier]: PremisEventIdentifier;
    [MetadataEnum.premisEventType]: string;
    [MetadataEnum.premisEventDateTime]: string;
    [MetadataEnum.premisLinkingObjectIdentifier]: PremisLinkingObjectIdentifier;
  }

  export interface PremisEventIdentifier {
    [MetadataEnum.premisEventIdentifierType]: string;
    [MetadataEnum.premisEventIdentifierValue]: string;
  }

  export interface PremisLinkingObjectIdentifier {
    [MetadataEnum.premisLinkingObjectIdentifierType]: string;
    [MetadataEnum.premisLinkingObjectIdentifierValue]: string;
  }

  export interface PremisObject {
    [MetadataEnum.premisObjectIdentifier]: PremisObjectIdentifier;
    [MetadataEnum.premisOriginalName]: string;
  }

  export interface PremisObjectIdentifier {
    [MetadataEnum.premisObjectIdentifierType]: string;
    [MetadataEnum.premisObjectIdentifierValue]: string;
  }

  /* PUBLIC */
  export interface Datacite {
    [MetadataEnum.dataciteResource]: DataciteResource;
  }

  export interface DataciteResource {
    [MetadataEnum.dataciteCreators]: DataciteCreators;
    [MetadataEnum.dataciteDates]: DataciteDates;
    [MetadataEnum.dataciteDescriptions]: DataciteDescriptions;
    [MetadataEnum.dataciteFormats]: DataciteFormats;
    [MetadataEnum.dataciteIdentifier]: DataciteIdentifier;
    [MetadataEnum.datacitePublicationYear]: number;
    [MetadataEnum.datacitePublisher]: string;
    [MetadataEnum.dataciteRelatedIdentifiers]: DataciteRelatedIdentifiers;
    [MetadataEnum.dataciteResourceType]: DataciteResourceType;
    [MetadataEnum.dataciteRightsList]: DataciteRightsList;
    [MetadataEnum.dataciteTitles]: DataciteTitles;
  }

  export interface DataciteCreators {
    [MetadataEnum.dataciteCreator]: DataciteCreator;
  }

  export interface DataciteCreator {
    [MetadataEnum.dataciteCreatorName]: string;
  }

  export interface DataciteDates {
    [MetadataEnum.dataciteDate]: DataciteDate;
  }

  export interface DataciteDate {
    [MetadataEnum.content]: string;
    [MetadataEnum.dateType]: string;
  }

  export interface DataciteDescriptions {
    [MetadataEnum.dataciteDescription]: DataciteDescription[];
  }

  export interface DataciteDescription {
    [MetadataEnum.descriptionType]: string;
    [MetadataEnum.content]?: string;
  }

  export interface DataciteFormats {
    [MetadataEnum.dataciteFormat]: string[];
  }

  export interface DataciteIdentifier {
    [MetadataEnum.content]: string;
    [MetadataEnum.identifierType]: string;
  }

  export interface DataciteRelatedIdentifiers {
    [MetadataEnum.dataciteRelatedIdentifier]: DataciteRelatedIdentifier;
  }

  export interface DataciteRelatedIdentifier {
    [MetadataEnum.content]: string;
    [MetadataEnum.relatedIdentifierType]: string;
    [MetadataEnum.relationType]: string;
  }

  export interface DataciteResourceType {
    [MetadataEnum.content]: string;
    [MetadataEnum.resourceTypeGeneral]: string;
  }

  export interface DataciteRightsList {
    [MetadataEnum.dataciteRights]: DataciteRights[];
  }

  export interface DataciteRights {
    [MetadataEnum.content]: string;
    [MetadataEnum.rightsURI]: string;
  }

  export interface DataciteTitles {
    [MetadataEnum.dataciteTitle]: string[];
  }
}

