import {Enums} from "@enums";

export interface ArchiveMetadataDataFile {
  resId?: string;
  index: string;
  type: string;
  metadata: ArchiveMetadataDataFile.Metadata;
  _links?: object;
}

export enum MetadataDataFileEnum {
  aipAccessLevel = "aip-access-level",
  aipOrganizationalUnit = "aip-organizational-unit",
  checksumsSha1 = "SHA-1",
  checksumsSha256 = "SHA-256",
  eventsFormatIdentification = "format-identification",
  eventsVirusCheck = "virusCheck",
  technicalMetadata = "technical-metadata",
  technicalMetadataImageColorSpace = "color-space",
}

export namespace ArchiveMetadataDataFile {
  export interface Metadata {
    [MetadataDataFileEnum.aipAccessLevel]: Enums.Deposit.AccessEnum;
    [MetadataDataFileEnum.aipOrganizationalUnit]: string;
    archiveId: string;
    checksums: Checksums;
    dlcm: Dlcm;
    events: Events;
    file: File;
    aip: Aip;
    format: Format;
    [MetadataDataFileEnum.technicalMetadata]: TechnicalMetadata;
    type: string;
  }

  export interface Checksums {
    MD5: string;
    [MetadataDataFileEnum.checksumsSha1]: string;
    [MetadataDataFileEnum.checksumsSha256]: string;
  }

  export interface Dlcm {
    category: Enums.DataFile.DataCategoryEnum;
    complianceLevel: Enums.DataFile.ComplianceLevelNumberEnum;
    type: Enums.DataFile.DataTypeEnum;
  }

  export interface Events {
    creation: EventsDate;
    [MetadataDataFileEnum.eventsFormatIdentification]: EventsDate;
    [MetadataDataFileEnum.eventsVirusCheck]: EventsDate;
  }

  export interface EventsDate {
    date: Date;
  }

  export interface File {
    fullName: string;
    name: string;
    path: string;
    size: number;
  }

  export interface Aip {
    id: string;
    size: number;
  }

  export interface Format {
    PRONOM: string;
    description: string;
    version: number | string;
  }

  export interface TechnicalMetadata {
    image: TechnicalMetadataImage;
  }

  export interface TechnicalMetadataImage {
    [MetadataDataFileEnum.technicalMetadataImageColorSpace]: string;
  }
}

