import {AbstractControl} from "@angular/forms";
import {
  isNotNullNorUndefined,
  MappingObjectUtil,
} from "solidify-frontend";

export class ValidationErrorHelper {
  static addError(fc: AbstractControl, errorKey: string): boolean {
    let errorAdded;
    let newError = {};
    if (isNotNullNorUndefined(fc.errors)) {
      newError = Object.assign({}, fc.errors);
      errorAdded = !MappingObjectUtil.has(newError, errorKey) || MappingObjectUtil.get(newError, errorKey) === false;
    } else {
      errorAdded = true;
    }
    MappingObjectUtil.set(newError, errorKey, true);
    fc.setErrors(newError);
    return errorAdded;
  }

  static removeError(fc: AbstractControl, errorKey: string): boolean {
    if (!fc.hasError(errorKey)) {
      return false;
    }
    let newError = undefined;
    if (MappingObjectUtil.size(fc.errors) > 1) {
      newError = Object.assign({}, fc.errors);
      MappingObjectUtil.delete(newError, errorKey);
    }
    fc.setErrors(newError);
    return true;
  }

  static removeAllErrors(fc: AbstractControl): boolean {
    if (MappingObjectUtil.size(fc.errors) === 0) {
      return false;
    }
    fc.setErrors(undefined);
    return true;
  }
}
