import {Renderer2} from "@angular/core";
import {environment} from "@environments/environment";
import {BaseResourceApiEnum} from "@shared/enums/api.enum";
import {
  isNotNullNorUndefined,
  urlSeparator,
} from "solidify-frontend";

export class TocHelper {
  static updateLinkToc(document: Document, renderer: Renderer2, classContainerLink: string, isUserGuide: boolean): void {
    let urlBase = BaseResourceApiEnum.docs;
    if (isUserGuide && isNotNullNorUndefined(environment.documentationTocUserGuidePath)) {
      urlBase = environment.documentationTocUserGuidePath;
    }
    const listA = document.querySelectorAll(`.${classContainerLink} a:not([active="true"])`);
    listA.forEach(a => {
      const existingHref = a.attributes["href"].value;
      renderer.setAttribute(a, "href", urlBase + urlSeparator + existingHref);
      renderer.setAttribute(a, "active", "true");
    });
  }
}
