import {IconInfos} from "@shared/components/presentationals/shared-icon/shared-icon.presentational";
import {IconLibEnum} from "@shared/enums/icon-lib.enum";
import {IconNameEnum} from "@shared/enums/icon-name.enum";

export class IconHelper {
  static getIcon(name: IconNameEnum): IconInfos | undefined {
    return IconHelper.listIcon.find(i => i.name === name);
  }

  static listIcon: IconInfos[] = [
    {
      name: IconNameEnum.organizationalUnit,
      lib: IconLibEnum.fontAwesome,
      icon: "building",
    },
    {
      name: IconNameEnum.deposit,
      lib: IconLibEnum.fontAwesome,
      icon: "file-upload",
    },
    {
      name: IconNameEnum.home,
      lib: IconLibEnum.fontAwesome,
      icon: "home",
    },
    {
      name: IconNameEnum.order,
      lib: IconLibEnum.fontAwesome,
      icon: "archive",
    },
    {
      name: IconNameEnum.preservationSpace,
      lib: IconLibEnum.fontAwesome,
      icon: "users",
    },
    {
      name: IconNameEnum.preservationPlanning,
      lib: IconLibEnum.fontAwesome,
      icon: "boxes",
    },
    {
      name: IconNameEnum.administration,
      lib: IconLibEnum.fontAwesome,
      icon: "cogs",
    },
    {
      name: IconNameEnum.profile,
      lib: IconLibEnum.materialIcon,
      icon: "account_circle",
    },
    {
      name: IconNameEnum.token,
      lib: IconLibEnum.materialIcon,
      icon: "vpn_key",
    },
    {
      name: IconNameEnum.logout,
      lib: IconLibEnum.materialIcon,
      icon: "power_settings_new",
    },
    {
      name: IconNameEnum.login,
      lib: IconLibEnum.materialIcon,
      icon: "account_circle",
    },
    {
      name: IconNameEnum.resId,
      lib: IconLibEnum.fontAwesome,
      icon: "key",
    },
    {
      name: IconNameEnum.history,
      lib: IconLibEnum.materialIcon,
      icon: "history",
    },
    {
      name: IconNameEnum.docDev,
      lib: IconLibEnum.fontAwesome,
      icon: "code",
    },
    {
      name: IconNameEnum.docUser,
      lib: IconLibEnum.materialIcon,
      icon: "help",
    },
    {
      name: IconNameEnum.appVersion,
      lib: IconLibEnum.fontAwesome,
      icon: "code-branch",
    },
    {
      name: IconNameEnum.cart,
      lib: IconLibEnum.materialIcon,
      icon: "shopping_cart",
    },
    {
      name: IconNameEnum.addToCart,
      lib: IconLibEnum.materialIcon,
      icon: "add_shopping_cart",
    },
    {
      name: IconNameEnum.search,
      lib: IconLibEnum.fontAwesome,
      icon: "search",
    },
    {
      name: IconNameEnum.back,
      lib: IconLibEnum.materialIcon,
      icon: "navigate_before",
    },
    {
      name: IconNameEnum.refresh,
      lib: IconLibEnum.materialIcon,
      icon: "refresh",
    },
    {
      name: IconNameEnum.delete,
      lib: IconLibEnum.materialIcon,
      icon: "delete",
    },
    {
      name: IconNameEnum.deleteAll,
      lib: IconLibEnum.materialIcon,
      icon: "delete_forever",
    },
    {
      name: IconNameEnum.create,
      lib: IconLibEnum.materialIcon,
      icon: "add",
    },
    {
      name: IconNameEnum.internalLink,
      lib: IconLibEnum.materialIcon,
      icon: "open_in_new ",
    },
    {
      name: IconNameEnum.externalLink,
      lib: IconLibEnum.materialIcon,
      icon: "language",
    },
    {
      name: IconNameEnum.edit,
      lib: IconLibEnum.materialIcon,
      icon: "edit",
    },
    {
      name: IconNameEnum.add,
      lib: IconLibEnum.materialIcon,
      icon: "add",
    },
    {
      name: IconNameEnum.close,
      lib: IconLibEnum.materialIcon,
      icon: "close",
    },
    {
      name: IconNameEnum.archiveBrowsing,
      lib: IconLibEnum.materialIcon,
      icon: "list",
    },
    {
      name: IconNameEnum.download,
      lib: IconLibEnum.materialIcon,
      icon: "file_download",
    },
    {
      name: IconNameEnum.sendRequest,
      lib: IconLibEnum.materialIcon,
      icon: "announcement",
    },
    {
      name: IconNameEnum.accessControlled,
      lib: IconLibEnum.materialIcon,
      icon: "announcement",
    },
    {
      name: IconNameEnum.roleManager,
      lib: IconLibEnum.fontAwesome,
      icon: "user-shield",
    },
    {
      name: IconNameEnum.roleSteward,
      lib: IconLibEnum.fontAwesome,
      icon: "user-md",
    },
    {
      name: IconNameEnum.roleApprover,
      lib: IconLibEnum.fontAwesome,
      icon: "user-check",
    },
    {
      name: IconNameEnum.roleCreator,
      lib: IconLibEnum.fontAwesome,
      icon: "user-edit",
    },
    {
      name: IconNameEnum.roleVisitor,
      lib: IconLibEnum.fontAwesome,
      icon: "user",
    },
    {
      name: IconNameEnum.myOrder,
      lib: IconLibEnum.fontAwesome,
      icon: "user",
    },
    {
      name: IconNameEnum.allOrder,
      lib: IconLibEnum.fontAwesome,
      icon: "users",
    },
    {
      name: IconNameEnum.metadata,
      lib: IconLibEnum.materialIcon,
      icon: "assignment",
    },
    {
      name: IconNameEnum.files,
      lib: IconLibEnum.materialIcon,
      icon: "insert_drive_file",
    },
    {
      name: IconNameEnum.associateArchive,
      lib: IconLibEnum.materialIcon,
      icon: "link",
    },
    {
      name: IconNameEnum.collection,
      lib: IconLibEnum.materialIcon,
      icon: "collections_bookmark",
    },
    {
      name: IconNameEnum.navigate,
      lib: IconLibEnum.materialIcon,
      icon: "forward",
    },
    {
      name: IconNameEnum.reserveDoi,
      lib: IconLibEnum.materialIcon,
      icon: "library_books",
    },
    {
      name: IconNameEnum.submit,
      lib: IconLibEnum.materialIcon,
      icon: "done_all",
    },
    {
      name: IconNameEnum.approve,
      lib: IconLibEnum.materialIcon,
      icon: "check",
    },
    {
      name: IconNameEnum.unapprove,
      lib: IconLibEnum.materialIcon,
      icon: "close",
    },
    {
      name: IconNameEnum.wait,
      lib: IconLibEnum.materialIcon,
      icon: "access_time",
    },
    {
      name: IconNameEnum.save,
      lib: IconLibEnum.materialIcon,
      icon: "save",
    },
    {
      name: IconNameEnum.uploadFile,
      lib: IconLibEnum.materialIcon,
      icon: "publish",
    },
    {
      name: IconNameEnum.uploadStructuredFiles,
      lib: IconLibEnum.materialIcon,
      icon: "unarchive",
    },
    {
      name: IconNameEnum.filesView,
      lib: IconLibEnum.materialIcon,
      icon: "list",
    },
    {
      name: IconNameEnum.foldersView,
      lib: IconLibEnum.materialIcon,
      icon: "folder_open",
    },
    {
      name: IconNameEnum.preview,
      lib: IconLibEnum.materialIcon,
      icon: "remove_red_eye",
    },
    {
      name: IconNameEnum.star,
      lib: IconLibEnum.materialIcon,
      icon: "star",
    },
    {
      name: IconNameEnum.star_empty,
      lib: IconLibEnum.materialIcon,
      icon: "star_border",
    },
    {
      name: IconNameEnum.move,
      lib: IconLibEnum.materialIcon,
      icon: "redo",
    },
    {
      name: IconNameEnum.information,
      lib: IconLibEnum.materialIcon,
      icon: "info",
    },
    {
      name: IconNameEnum.contributor,
      lib: IconLibEnum.materialIcon,
      icon: "group",
    },
    {
      name: IconNameEnum.requestInbox,
      lib: IconLibEnum.materialIcon,
      icon: "mail",
    },
    {
      name: IconNameEnum.requestSent,
      lib: IconLibEnum.materialIcon,
      icon: "send",
    },
    {
      name: IconNameEnum.sip,
      lib: IconLibEnum.fontAwesome,
      icon: "paper-plane",
    },
    {
      name: IconNameEnum.dip,
      lib: IconLibEnum.fontAwesome,
      icon: "cart-arrow-down",
    },
    {
      name: IconNameEnum.aip,
      lib: IconLibEnum.fontAwesome,
      icon: "archive",
    },
    {
      name: IconNameEnum.monitoring,
      lib: IconLibEnum.fontAwesome,
      icon: "user-md",
    },
    {
      name: IconNameEnum.jobs,
      lib: IconLibEnum.fontAwesome,
      icon: "robot",
    },
    {
      name: IconNameEnum.archivingStatus,
      lib: IconLibEnum.fontAwesome,
      icon: "clipboard-check",
    },
    {
      name: IconNameEnum.aipDownloaded,
      lib: IconLibEnum.fontAwesome,
      icon: "cart-arrow-down",
    },
    {
      name: IconNameEnum.storagion,
      lib: IconLibEnum.fontAwesome,
      icon: "server",
    },
    {
      name: IconNameEnum.simpleChecksum,
      lib: IconLibEnum.materialIcon,
      icon: "refresh",
    },
    {
      name: IconNameEnum.doubleChecksum,
      lib: IconLibEnum.materialIcon,
      icon: "sync",
    },
    {
      name: IconNameEnum.reindex,
      lib: IconLibEnum.materialIcon,
      icon: "repeat",
    },
    {
      name: IconNameEnum.check,
      lib: IconLibEnum.materialIcon,
      icon: "check",
    },
    {
      name: IconNameEnum.init,
      lib: IconLibEnum.materialIcon,
      icon: "power",
    },
    {
      name: IconNameEnum.run,
      lib: IconLibEnum.materialIcon,
      icon: "play_arrow",
    },
    {
      name: IconNameEnum.resume,
      lib: IconLibEnum.materialIcon,
      icon: "play_circle_filled",
    },
    {
      name: IconNameEnum.resumeAll,
      lib: IconLibEnum.materialIcon,
      icon: "play_circle_outline",
    },
    {
      name: IconNameEnum.notIgnore,
      lib: IconLibEnum.materialIcon,
      icon: "check_circle",
    },
    {
      name: IconNameEnum.orderReady,
      lib: IconLibEnum.materialIcon,
      icon: "check_circle",
    },
    {
      name: IconNameEnum.orderInProgress,
      lib: IconLibEnum.materialIcon,
      icon: "autorenew",
    },
    {
      name: IconNameEnum.orderInError,
      lib: IconLibEnum.materialIcon,
      icon: "error",
    },
    {
      name: IconNameEnum.submissionPolicies,
      lib: IconLibEnum.fontAwesome,
      icon: "user-check",
    },
    {
      name: IconNameEnum.preservationPolicies,
      lib: IconLibEnum.fontAwesome,
      icon: "history",
    },
    {
      name: IconNameEnum.disseminationPolicies,
      lib: IconLibEnum.fontAwesome,
      icon: "cart-arrow-down",
    },
    {
      name: IconNameEnum.licenses,
      lib: IconLibEnum.fontAwesome,
      icon: "copyright",
    },
    {
      name: IconNameEnum.institutions,
      lib: IconLibEnum.fontAwesome,
      icon: "university",
    },
    {
      name: IconNameEnum.researchDomains,
      lib: IconLibEnum.fontAwesome,
      icon: "microscope",
    },
    {
      name: IconNameEnum.users,
      lib: IconLibEnum.fontAwesome,
      icon: "user-circle",
    },
    {
      name: IconNameEnum.roles,
      lib: IconLibEnum.fontAwesome,
      icon: "id-badge",
    },
    {
      name: IconNameEnum.oaiSets,
      lib: IconLibEnum.fontAwesome,
      icon: "passport",
    },
    {
      name: IconNameEnum.oauth2Clients,
      lib: IconLibEnum.fontAwesome,
      icon: "passport",
    },
    {
      name: IconNameEnum.peoples,
      lib: IconLibEnum.fontAwesome,
      icon: "user",
    },
    {
      name: IconNameEnum.fundingAgencies,
      lib: IconLibEnum.fontAwesome,
      icon: "hand-holding-usd",
    },
    {
      name: IconNameEnum.indexFieldAliases,
      lib: IconLibEnum.fontAwesome,
      icon: "search",
    },
    {
      name: IconNameEnum.archiveAcl,
      lib: IconLibEnum.fontAwesome,
      icon: "lock",
    },
    {
      name: IconNameEnum.languages,
      lib: IconLibEnum.fontAwesome,
      icon: "language",
    },
    {
      name: IconNameEnum.metadataTypes,
      lib: IconLibEnum.fontAwesome,
      icon: "table",
    },
    {
      name: IconNameEnum.notifications,
      lib: IconLibEnum.fontAwesome,
      icon: "envelope",
    },
    {
      name: IconNameEnum.passwordVisible,
      lib: IconLibEnum.fontAwesome,
      icon: "eye",
    },
    {
      name: IconNameEnum.passwordHide,
      lib: IconLibEnum.fontAwesome,
      icon: "eye-slash",
    },
    {
      name: IconNameEnum.testFile,
      lib: IconLibEnum.materialIcon,
      icon: "check",
    },
    {
      name: IconNameEnum.folderEmpty,
      lib: IconLibEnum.fontAwesome,
      icon: "folder",
    },
    {
      name: IconNameEnum.folderOpened,
      lib: IconLibEnum.fontAwesome,
      icon: "folder-open",
    },
    {
      name: IconNameEnum.folderClosed,
      lib: IconLibEnum.fontAwesome,
      icon: "folder-plus",
    },
    {
      name: IconNameEnum.expandAll,
      lib: IconLibEnum.materialIcon,
      icon: "unfold_more",
    },
    {
      name: IconNameEnum.collapseAll,
      lib: IconLibEnum.materialIcon,
      icon: "unfold_less",
    },
    {
      name: IconNameEnum.send,
      lib: IconLibEnum.materialIcon,
      icon: "send",
    },
    {
      name: IconNameEnum.clear,
      lib: IconLibEnum.materialIcon,
      icon: "clear",
    },
    {
      name: IconNameEnum.done,
      lib: IconLibEnum.materialIcon,
      icon: "done",
    },
    {
      name: IconNameEnum.update,
      lib: IconLibEnum.materialIcon,
      icon: "sync",
    },
    {
      name: IconNameEnum.emptyCart,
      lib: IconLibEnum.materialIcon,
      icon: "remove_shopping_cart",
    },
    {
      name: IconNameEnum.copyToClipboard,
      lib: IconLibEnum.materialIcon,
      icon: "filter_none",
    },
    {
      name: IconNameEnum.notFound,
      lib: IconLibEnum.materialIcon,
      icon: "mood_bad",
    },
    {
      name: IconNameEnum.up,
      lib: IconLibEnum.materialIcon,
      icon: "keyboard_arrow_up",
    },
    {
      name: IconNameEnum.down,
      lib: IconLibEnum.materialIcon,
      icon: "keyboard_arrow_down",
    },
    {
      name: IconNameEnum.personAdd,
      lib: IconLibEnum.materialIcon,
      icon: "person_add",
    },
    {
      name: IconNameEnum.redo,
      lib: IconLibEnum.fontAwesome,
      icon: "redo-alt",
    },
    {
      name: IconNameEnum.sort,
      lib: IconLibEnum.materialIcon,
      icon: "format_list_numbered_rtl",
    },
    {
      name: IconNameEnum.clearCache,
      lib: IconLibEnum.materialIcon,
      icon: "delete_sweep",
    },
    {
      name: IconNameEnum.warning,
      lib: IconLibEnum.materialIcon,
      icon: "warning",
    },
    {
      name: IconNameEnum.autoUpdate,
      lib: IconLibEnum.materialIcon,
      icon: "autorenew",
    },
    {
      name: IconNameEnum.fingerprint,
      lib: IconLibEnum.materialIcon,
      icon: "fingerprint",
    },
    {
      name: IconNameEnum.http,
      lib: IconLibEnum.materialIcon,
      icon: "http",
    },
    {
      name: IconNameEnum.closeChip,
      lib: IconLibEnum.fontAwesome,
      icon: "times-circle",
    },
    {
      name: IconNameEnum.success,
      lib: IconLibEnum.materialIcon,
      icon: "check_circle",
    },
    {
      name: IconNameEnum.error,
      lib: IconLibEnum.materialIcon,
      icon: "error",
    },
    {
      name: IconNameEnum.zoomOut,
      lib: IconLibEnum.materialIcon,
      icon: "zoom_out",
    },
    {
      name: IconNameEnum.zoomIn,
      lib: IconLibEnum.materialIcon,
      icon: "zoom_in",
    },
    {
      name: IconNameEnum.menuButtons,
      lib: IconLibEnum.fontAwesome,
      icon: "ellipsis-v",
    },
    {
      name: IconNameEnum.orcid,
      lib: IconLibEnum.image,
      icon: "orcid.png",
    },
    {
      name: IconNameEnum.doi,
      lib: IconLibEnum.image,
      icon: "doi.svg",
    },
    {
      name: IconNameEnum.archive,
      lib: IconLibEnum.fontAwesome,
      icon: "book",
    },
    {
      name: IconNameEnum.unigeBlack,
      lib: IconLibEnum.image,
      icon: "unigelogo-black.svg",
    },
    {
      name: IconNameEnum.unigeWhite,
      lib: IconLibEnum.image,
      icon: "unigelogo-white.svg",
    },
    {
      name: IconNameEnum.theme,
      lib: IconLibEnum.materialIcon,
      icon: "style",
    },
    {
      name: IconNameEnum.darkMode,
      lib: IconLibEnum.materialIcon,
      icon: "brightness_medium",
    },
    {
      name: IconNameEnum.creationDate,
      lib: IconLibEnum.materialIcon,
      icon: "event_note",
    },
    {
      name: IconNameEnum.defaultValue,
      lib: IconLibEnum.materialIcon,
      icon: "settings",
    },
    {
      name: IconNameEnum.change,
      lib: IconLibEnum.materialIcon,
      icon: "swap_horiz",
    },
    {
      name: IconNameEnum.trueValue,
      lib: IconLibEnum.materialIcon,
      icon: "check_circle_outline",
    },
    {
      name: IconNameEnum.falseValue,
      lib: IconLibEnum.materialIcon,
      icon: "highlight_off",
    },
    {
      name: IconNameEnum.dispose,
      lib: IconLibEnum.materialIcon,
      icon: "delete_forever",
    },
    {
      name: IconNameEnum.approveDisposal,
      lib: IconLibEnum.materialIcon,
      icon: "check",
    },
    {
      name: IconNameEnum.approveDisposalByOrgUnit,
      lib: IconLibEnum.materialIcon,
      icon: "check",
    },
    {
      name: IconNameEnum.extendRetention,
      lib: IconLibEnum.materialIcon,
      icon: "schedule",
    },
    {
      name: IconNameEnum.listView,
      lib: IconLibEnum.materialIcon,
      icon: "view_list",
    },
    {
      name: IconNameEnum.tilesView,
      lib: IconLibEnum.materialIcon,
      icon: "view_module",
    },
    {
      name: IconNameEnum.accessLevelRestricted,
      lib: IconLibEnum.image,
      icon: "restricted.svg",
    },
    {
      name: IconNameEnum.accessLevelClosed,
      lib: IconLibEnum.image,
      icon: "closed.svg",
    },
    {
      name: IconNameEnum.accessLevelPublic,
      lib: IconLibEnum.image,
      icon: "public.svg",
    },
    {
      name: IconNameEnum.accessLevelUndefined,
      lib: IconLibEnum.image,
      icon: "access-level-undefined.svg",
    },
    {
      name: IconNameEnum.uploadImage,
      lib: IconLibEnum.materialIcon,
      icon: "add_a_photo",
    },
    {
      name: IconNameEnum.help,
      lib: IconLibEnum.materialIcon,
      icon: "help",
    },
    {
      name: IconNameEnum.maintenance,
      lib: IconLibEnum.materialIcon,
      icon: "settings",
    },
    {
      name: IconNameEnum.offline,
      lib: IconLibEnum.materialIcon,
      icon: "power_settings_new",
    },
    {
      name: IconNameEnum.viewNumber,
      lib: IconLibEnum.fontAwesome,
      icon: "eye",
    },
    {
      name: IconNameEnum.downloadNumber,
      lib: IconLibEnum.materialIcon,
      icon: "get_app",
    },
    {
      name: IconNameEnum.sortUndefined,
      lib: IconLibEnum.materialIcon,
      icon: "filter_list",
    },
    {
      name: IconNameEnum.sortAscending,
      lib: IconLibEnum.fontAwesome,
      icon: "sort-amount-up-alt",
    },
    {
      name: IconNameEnum.sortDescending,
      lib: IconLibEnum.fontAwesome,
      icon: "sort-amount-down",
    },
    {
      name: IconNameEnum.noPreview,
      lib: IconLibEnum.materialIcon,
      icon: "insert_drive_file",
    },
    {
      name: IconNameEnum.fullScreenEnter,
      lib: IconLibEnum.materialIcon,
      icon: "fullscreen",
    },
    {
      name: IconNameEnum.fullScreenLeave,
      lib: IconLibEnum.materialIcon,
      icon: "fullscreen_exit",
    },
    {
      name: IconNameEnum.guidedTour,
      lib: IconLibEnum.materialIcon,
      icon: "beenhere",
    },
    {
      name: IconNameEnum.dataSensitivity,
      lib: IconLibEnum.materialIcon,
      icon: "local_offer",
    },
    {
      name: IconNameEnum.plus,
      lib: IconLibEnum.fontAwesome,
      icon: "plus-square",
    },
    {
      name: IconNameEnum.minus,
      lib: IconLibEnum.fontAwesome,
      icon: "minus-square",
    },
    {
      name: IconNameEnum.rate,
      lib: IconLibEnum.materialIcon,
      icon: "stars",
    },
    {
      name: IconNameEnum.dataSensitivityPartiallySupportedOrange,
      lib: IconLibEnum.image,
      icon: "local-offer-disabled-orange.svg",
    },
    {
      name: IconNameEnum.dataSensitivityPartiallySupportedRed,
      lib: IconLibEnum.image,
      icon: "local-offer-disabled-red.svg",
    },
    {
      name: IconNameEnum.dataSensitivityPartiallySupportedCrimson,
      lib: IconLibEnum.image,
      icon: "local-offer-disabled-crimson.svg",
    },
    {
      name: IconNameEnum.markAsUnread,
      lib: IconLibEnum.materialIcon,
      icon: "markunread",
    },
    {
      name: IconNameEnum.markAsRead,
      lib: IconLibEnum.materialIcon,
      icon: "drafts",
    },
    {
      name: IconNameEnum.privacy,
      lib: IconLibEnum.materialIcon,
      icon: "vpn_lock",
    },
    {
      name: IconNameEnum.more,
      lib: IconLibEnum.materialIcon,
      icon: "more_horiz",
    },
  ];
}
