import {isNullOrUndefined} from "solidify-frontend";

export class DomHelper {
  static getParentWithTag(target: Element, possibleParentTags: string[], stopElement: Element): undefined | Element {
    if (target === stopElement) {
      return undefined;
    }
    if (possibleParentTags.includes(target.tagName.toLowerCase())) {
      return target;
    }
    return this.getParentWithTag(target.parentElement, possibleParentTags, stopElement);
  }

  static getParentChildrenWithTag(target: Element, possibleChildrenTags: string[]): undefined | Element {
    const result = target.querySelector(possibleChildrenTags.join(","));
    if (isNullOrUndefined(result)) {
      return undefined;
    }
    return result;
  }
}
