import {Enums} from "@enums";
import {isNotNullNorUndefined} from "solidify-frontend";

export class DataSensitivityHelper {
  static getColor(dataSensitivity: Enums.Deposit.DataSensitivityEnum): DataSensitivityColor {
    switch (dataSensitivity) {
      case Enums.Deposit.DataSensitivityEnum.BLUE:
        return "blue";
      case Enums.Deposit.DataSensitivityEnum.GREEN:
        return "green";
      case Enums.Deposit.DataSensitivityEnum.YELLOW:
        return "yellow";
      case Enums.Deposit.DataSensitivityEnum.ORANGE:
        return "orange";
      case Enums.Deposit.DataSensitivityEnum.RED:
        return "red";
      case Enums.Deposit.DataSensitivityEnum.CRIMSON:
        return "crimson";
      case Enums.Deposit.DataSensitivityEnum.UNDEFINED:
      default:
        return "undefined";
    }
  }

  static isPartiallySupported(dataSensitivity: Enums.Deposit.DataSensitivityEnum): boolean {
    return isNotNullNorUndefined(dataSensitivity) &&
      (dataSensitivity === Enums.Deposit.DataSensitivityEnum.ORANGE
        || dataSensitivity === Enums.Deposit.DataSensitivityEnum.RED
        || dataSensitivity === Enums.Deposit.DataSensitivityEnum.CRIMSON);
  }
}

export type DataSensitivityColor = "blue" | "green" | "yellow" | "orange" | "red" | "crimson" | "undefined";
