import {Enums} from "@enums";
import {MARK_AS_TRANSLATABLE} from "solidify-frontend";

export class DataCategoryHelper {
  static getDataTypeForDataCategory(dataCategory: Enums.DataFile.DataCategoryEnum): Enums.DataFile.DataTypeEnum[] {
    // TODO TO FIX TRANSLATION SHOULD NOT WORK HERE
    switch (dataCategory) {
      case Enums.DataFile.DataCategoryEnum.Primary:
        return [
          MARK_AS_TRANSLATABLE(Enums.DataFile.DataTypeEnum.Observational) as Enums.DataFile.DataTypeEnum,
          MARK_AS_TRANSLATABLE(Enums.DataFile.DataTypeEnum.Experimental) as Enums.DataFile.DataTypeEnum,
          MARK_AS_TRANSLATABLE(Enums.DataFile.DataTypeEnum.Simulation) as Enums.DataFile.DataTypeEnum,
          MARK_AS_TRANSLATABLE(Enums.DataFile.DataTypeEnum.Derived) as Enums.DataFile.DataTypeEnum,
          MARK_AS_TRANSLATABLE(Enums.DataFile.DataTypeEnum.Reference) as Enums.DataFile.DataTypeEnum,
          MARK_AS_TRANSLATABLE(Enums.DataFile.DataTypeEnum.Digitalized) as Enums.DataFile.DataTypeEnum,
        ];
      case Enums.DataFile.DataCategoryEnum.Secondary:
        return [
          MARK_AS_TRANSLATABLE(Enums.DataFile.DataTypeEnum.Publication) as Enums.DataFile.DataTypeEnum,
          MARK_AS_TRANSLATABLE(Enums.DataFile.DataTypeEnum.DataPaper) as Enums.DataFile.DataTypeEnum,
          MARK_AS_TRANSLATABLE(Enums.DataFile.DataTypeEnum.Documentation) as Enums.DataFile.DataTypeEnum,
        ];
      case Enums.DataFile.DataCategoryEnum.Package:
        return [
          MARK_AS_TRANSLATABLE(Enums.DataFile.DataTypeEnum.InformationPackage) as Enums.DataFile.DataTypeEnum,
          MARK_AS_TRANSLATABLE(Enums.DataFile.DataTypeEnum.Metadata) as Enums.DataFile.DataTypeEnum,
          MARK_AS_TRANSLATABLE(Enums.DataFile.DataTypeEnum.CustomMetadata) as Enums.DataFile.DataTypeEnum,
        ];
      case Enums.DataFile.DataCategoryEnum.Software:
        return [
          MARK_AS_TRANSLATABLE(Enums.DataFile.DataTypeEnum.Code) as Enums.DataFile.DataTypeEnum,
          MARK_AS_TRANSLATABLE(Enums.DataFile.DataTypeEnum.Binaries) as Enums.DataFile.DataTypeEnum,
          MARK_AS_TRANSLATABLE(Enums.DataFile.DataTypeEnum.VirtualMachine) as Enums.DataFile.DataTypeEnum,
        ];
      case Enums.DataFile.DataCategoryEnum.Internal:
        return [
          MARK_AS_TRANSLATABLE(Enums.DataFile.DataTypeEnum.DatasetThumbnail) as Enums.DataFile.DataTypeEnum,
          MARK_AS_TRANSLATABLE(Enums.DataFile.DataTypeEnum.DatafileThumbnail) as Enums.DataFile.DataTypeEnum,
        ];
    }
  }

  static getListDataCategory(): Enums.DataFile.DataCategoryEnum[] {
    // TODO TO FIX TRANSLATION SHOULD NOT WORK HERE
    return [
      MARK_AS_TRANSLATABLE(Enums.DataFile.DataCategoryEnum.Primary) as Enums.DataFile.DataCategoryEnum,
      MARK_AS_TRANSLATABLE(Enums.DataFile.DataCategoryEnum.Secondary) as Enums.DataFile.DataCategoryEnum,
      MARK_AS_TRANSLATABLE(Enums.DataFile.DataCategoryEnum.Package) as Enums.DataFile.DataCategoryEnum,
      MARK_AS_TRANSLATABLE(Enums.DataFile.DataCategoryEnum.Software) as Enums.DataFile.DataCategoryEnum,
    ];
  }
}
