import {Metadata} from "@app/models";
import {Enums} from "@enums";
import {Archive} from "@home/models/archive.model";
import {FileSizePipe} from "@shared/pipes/file-size.pipe";
import {MetadataUtil} from "@shared/utils/metadata.util";
import {
  EnumUtil,
  isNullOrUndefined,
} from "solidify-frontend";

export class ArchiveHelper {
  private static _fileSizePipe: FileSizePipe = new FileSizePipe();

  static adaptListArchivesMetadataInArchive(listArchivesMetadata: Metadata[]): Archive[] {
    const newList: Archive[] = [];

    listArchivesMetadata.forEach((archive: Metadata) => {
      newList.push(this.adaptArchiveMetadataInArchive(archive));
    });
    return newList;
  }

  static adaptArchiveMetadataInArchive(archiveMetadata: Metadata): Archive {
    if (isNullOrUndefined(archiveMetadata)) {
      return undefined;
    }
    const size = MetadataUtil.getSize(archiveMetadata.metadata);
    const accessLevel = archiveMetadata.currentAccess;
    const dataSensibility = MetadataUtil.getDataSensibility(archiveMetadata.metadata);
    return {
      resId: archiveMetadata.resId,
      organizationalUnitId: MetadataUtil.getOrganizationalUnitResId(archiveMetadata.metadata),
      title: MetadataUtil.getTitle(archiveMetadata.metadata),
      description: MetadataUtil.getDescriptionAbstract(archiveMetadata.metadata),
      yearPublicationDate: MetadataUtil.getPublicationYear(archiveMetadata.metadata),
      dataSensitivity: dataSensibility,
      dataSensitivityToTranslate: EnumUtil.getLabel(Enums.Deposit.DataSensitivityEnumTranslate, dataSensibility),
      accessLevel: accessLevel,
      accessLevelToTranslate: EnumUtil.getLabel(Enums.Deposit.AccessEnumTranslate, accessLevel),
      sizeDisplay: isNullOrUndefined(size) ? undefined : this._fileSizePipe.transform(size),
      size: isNullOrUndefined(size) ? undefined : size,
      files: MetadataUtil.getFileNumber(archiveMetadata.metadata),
      contributors: MetadataUtil.getContributors(archiveMetadata.metadata),
      archiveMetadata: archiveMetadata,
      withThumbnail: MetadataUtil.getWithThumbnail(archiveMetadata.metadata),
      isCollection: MetadataUtil.isCollection(archiveMetadata.metadata),
    } as Archive;
  }
}
