import {Enums} from "@enums";

export class AccessLevelHelper {
  static getColor(accessLevel: Enums.Deposit.AccessEnum): AccessLevelColor {
    switch (accessLevel) {
      case Enums.Deposit.AccessEnum.RESTRICTED:
        return "orange";
      case Enums.Deposit.AccessEnum.CLOSED:
        return "red";
      case Enums.Deposit.AccessEnum.PUBLIC:
      default:
        return "green";
    }
  }
}

export type AccessLevelColor = "red" | "orange" | "green";

