import {Injectable} from "@angular/core";
import {CanDeactivate} from "@angular/router";
import {Store} from "@ngxs/store";
import {ICanDeactivate} from "@shared/models/can-deactivate.model";

@Injectable({
  providedIn: "root",
})
export class PreventLeaveGuardService implements CanDeactivate<ICanDeactivate> {
  constructor(private _store: Store) {
  }

  canDeactivate(component: ICanDeactivate): boolean {
    return false;
  }
}
