import {Injectable} from "@angular/core";
import {
  ActivatedRouteSnapshot,
  CanActivate,
  Router,
} from "@angular/router";
import {Store} from "@ngxs/store";
import {AppRoutesEnum} from "@shared/enums/routes.enum";
import {DlcmData} from "@shared/models/dlcm-route.model";
import {SecurityService} from "@shared/services/security.service";
import {
  ApiService,
  isNullOrUndefined,
  MARK_AS_TRANSLATABLE,
  NotificationService,
} from "solidify-frontend";

@Injectable({
  providedIn: "root",
})
export class OrganizationalUnitRoleGuardService implements CanActivate {
  constructor(public router: Router,
              public store: Store,
              public apiService: ApiService,
              private readonly _securityService: SecurityService,
              private readonly _notificationService: NotificationService) {
  }

  canActivate(route: ActivatedRouteSnapshot): boolean {
    const data = route.data as DlcmData;
    const orgUnitPermissionNeed = isNullOrUndefined(data) ? [] : data.orgUnitPermissionNeed;
    let orgUnitId = route.parent.params[AppRoutesEnum.paramIdWithoutPrefixParam];
    if (isNullOrUndefined(orgUnitId)) {
      orgUnitId = route.parent.parent.params[AppRoutesEnum.paramIdWithoutPrefixParam];
    }
    if (isNullOrUndefined(orgUnitId)) {
      console.warn("Unable to extract orgUnitId from url");
      return false;
    }
    if (orgUnitPermissionNeed.length === 0) {
      return true;
    }
    if (this._securityService.isRootOrAdmin()) {
      return true;
    }
    const authorized = orgUnitPermissionNeed.indexOf(this._securityService.getRoleEnumInOrgUnit(orgUnitId)) !== -1;
    if (authorized === false) {
      this._notificationService.showWarning(MARK_AS_TRANSLATABLE("organizationalUnit.security.notification.noRightForThisAction"));
    }
    return authorized;
  }
}
