import {Injectable} from "@angular/core";
import {
  ActivatedRouteSnapshot,
  CanActivate,
  Router,
} from "@angular/router";
import {PreservationSpaceOrganizationalUnitAction} from "@app/features/preservation-space/organizational-unit/stores/preservation-space-organizational-unit.action";
import {AppState} from "@app/stores/app.state";
import {Navigate} from "@ngxs/router-plugin";
import {
  Actions,
  Store,
} from "@ngxs/store";
import {
  AppRoutesEnum,
  RoutesEnum,
} from "@shared/enums/routes.enum";
import {TourRouteIdEnum} from "@shared/enums/tour-route-id.enum";
import {SecurityService} from "@shared/services/security.service";
import {
  ApiService,
  MemoizedUtil,
  NotificationService,
} from "solidify-frontend";

@Injectable({
  providedIn: "root",
})
export class OrganizationalUnitComputeIsManagerGuardService implements CanActivate {
  constructor(public router: Router,
              public store: Store,
              public apiService: ApiService,
              private readonly _securityService: SecurityService,
              private readonly _notificationService: NotificationService,
              private readonly _actions$: Actions) {
  }

  canActivate(route: ActivatedRouteSnapshot): boolean {
    const orgUnitId = route.params[AppRoutesEnum.paramIdWithoutPrefixParam];
    const isInTourMode = MemoizedUtil.selectSnapshot(this.store, AppState, state => state.isInTourMode);
    const isOrgUnitIdForTour = orgUnitId === TourRouteIdEnum.tourOrgUnitId;
    if (isOrgUnitIdForTour || isInTourMode) {
      const isAuthorizedToDisplayTour = isOrgUnitIdForTour && isInTourMode;
      if (!isAuthorizedToDisplayTour) {
        this.store.dispatch(new Navigate([RoutesEnum.preservationSpaceOrganizationalUnit]));
      }
      return isAuthorizedToDisplayTour;
    }
    const authorized = this._securityService.isManagerOfOrgUnit(orgUnitId);
    this.store.dispatch(new PreservationSpaceOrganizationalUnitAction.SaveCurrentUserIsManager(authorized));
    return true;
  }
}
