import {Injectable} from "@angular/core";
import {
  ActivatedRouteSnapshot,
  CanActivate,
  Router,
} from "@angular/router";
import {Store} from "@ngxs/store";
import {AppRoutesEnum} from "@shared/enums/routes.enum";
import {SecurityService} from "@shared/services/security.service";
import {Observable} from "rxjs";
import {
  ApiService,
  isNullOrUndefined,
} from "solidify-frontend";

@Injectable({
  providedIn: "root",
})
export class DepositRoleGuardEditService implements CanActivate {
  constructor(public router: Router,
              public store: Store,
              public apiService: ApiService,
              private readonly _securityService: SecurityService) {
  }

  canActivate(route: ActivatedRouteSnapshot): Observable<boolean> {
    let depositId: string = route.parent.parent.params[AppRoutesEnum.paramIdWithoutPrefixParam];
    if (isNullOrUndefined(depositId)) {
      depositId = route.parent.params[AppRoutesEnum.paramIdWithoutPrefixParam];
    }
    return this._securityService.canEditDepositById(depositId);
  }
}
