import {environment} from "@environments/environment";
import {FileInput} from "@shared/filevisualizer/models/file-info.model";
import {AbstractFileVisualizer} from "@shared/filevisualizer/services/abstract-file-visualizer.service";
import {isTruthyObject} from "solidify-frontend";

export class VideoFileVisualizerService extends AbstractFileVisualizer {

  type: string = "videoPlugin";

  video: HTMLVideoElement = null;

  canHandle(fileInfo: FileInput): boolean {
    if (!isTruthyObject(fileInfo)) {
      return false;
    } else {
      return this.canHandleByExtension(fileInfo) || this.canHandleByMimeTypeContentType(fileInfo) || this.canHandleByPuid(fileInfo);
    }
  }

  canHandleByExtension(fileInfo: FileInput): boolean {
    if (!isTruthyObject(fileInfo)) {
      return false;
    } else {
      return environment.visualizationMovieExtensions.some(value => value === fileInfo.fileExtension);
    }
  }

  canHandleWithSize(fileInfo: FileInput): boolean {
    if (!isTruthyObject(fileInfo)) {
      return false;
    } else {
      return fileInfo.dataFile.fileSize <= environment.visualizationMaxSizeFile;
    }
  }

  canHandleByMimeTypeContentType(fileInfo: FileInput): boolean {
    if (!isTruthyObject(fileInfo)) {
      return false;
    } else {
      return environment.visualizationMovieContentType.some(value => value === fileInfo.dataFile.fileFormat?.contentType) || environment.visualizationMovieMimeType.some(value => value === fileInfo.dataFile.fileFormat.contentType);
    }
  }

  isVisualizationOnGoing(fileInfo: FileInput, domElement: Element): boolean {
    return isTruthyObject(this.video);
  }

  canHandleByPuid(fileInfo: FileInput): boolean {
    if (!isTruthyObject(fileInfo)) {
      return false;
    } else {
      return environment.visualizationMoviePronomId.some(value => value === fileInfo.dataFile.fileFormat.puid);
    }
  }

  closeVisualizer(fileInfo: FileInput, domElement: Element): void {
    domElement.remove();
    this.video = null;
  }

  convertVideoToClassicalFormat(fileInfo: FileInput, domElement: Element): void {
    // TODO
  }

  needToConvert(fileInfo: FileInput, domElement: Element): boolean {
    return false;
  }

  openVisualizer(fileInfo: FileInput, domElement: Element): void {
    if (this.needToConvert(fileInfo, domElement)) {
      this.convertVideoToClassicalFormat(fileInfo, domElement);
    }
    this.video = new HTMLVideoElement();
    const url = URL.createObjectURL(fileInfo.blob);
    this.video.src = url;
    this.video.style.maxHeight = "100%";
    this.video.style.maxWidth = "100%";
    this.video.style.backgroundColor = "black";
    domElement.appendChild(this.video);
  }

  doAction(fileInfo: FileInput, domElement: Element): void {
  }

  isZoomSupported(): boolean {
    return false;
  }

  handleZoom(zoomEnable: boolean, fileInfo: FileInput, domElement: Element): void {
  }

  isFullScreenSupported(): boolean {
    return false;
  }
}
