import {Injectable} from "@angular/core";
import {environment} from "@environments/environment";
import {FileInput} from "@shared/filevisualizer/models/file-info.model";
import {AbstractFileVisualizer} from "@shared/filevisualizer/services/abstract-file-visualizer.service";
import {isTruthyObject} from "solidify-frontend";

@Injectable()
export class SmeFileVisualizerService extends AbstractFileVisualizer {

  type: string = "smePlugin";

  canHandle(fileInfo: FileInput): boolean {
    if (!isTruthyObject(fileInfo)) {
      return false;
    } else {
      return this.canHandleByExtension(fileInfo) || this.canHandleByMimeTypeContentType(fileInfo) || this.canHandleByPuid(fileInfo);
    }
  }

  canHandleByExtension(fileInfo: FileInput): boolean {
    if (!isTruthyObject(fileInfo)) {
      return false;
    } else {
      return environment.visualizationSmeExtension.some(value => value === fileInfo.fileExtension);
    }
  }

  isVisualizationOnGoing(fileInfo: FileInput, domElement: Element): boolean {
    return false;
  }

  canHandleWithSize(fileInfo: FileInput): boolean {
    if (!isTruthyObject(fileInfo)) {
      return false;
    } else {
      return fileInfo.dataFile.fileSize <= environment.visualizationMaxSizeFile;
    }
  }

  canHandleByMimeTypeContentType(fileInfo: FileInput): boolean {
    if (!isTruthyObject(fileInfo)) {
      return false;
    } else {
      return environment.visualizationSmeContentType.some(value => value === fileInfo.dataFile.fileFormat?.contentType) || environment.visualizationSmeMimeType.some(value => value === fileInfo.dataFile.fileFormat.contentType);
    }
  }

  canHandleByPuid(fileInfo: FileInput): boolean {
    if (!isTruthyObject(fileInfo)) {
      return false;
    } else {
      return environment.visualizationSmePronomId.some(value => value === fileInfo.dataFile.fileFormat?.puid);
    }
  }

  closeVisualizer(fileInfo: FileInput, domElement: Element): void {
    domElement.remove();
  }

  openVisualizer(fileInfo: FileInput, domElement: Element): void {
    const iframe = document.createElement("iframe");
    iframe.style.overflow = "hidden";
    const fr = new FileReader();
    fr.onloadend = ((e) => {
      const molText = JSON.stringify(fr.result);
      const html = `
<div id="jsme_container"></div>
<script type="text/javascript" src="./assets/jsme/jsme/jsme.nocache.js"></script>
<script>
    function jsmeOnLoad() {
        jsmeApplet = new JSApplet.JSME("jsme_container", "380px", "340px", {
           "options" : "depict"
        });
        jsmeApplet.setAfterStructureModifiedCallback(readMolFile());
}
function readMolFile() {
        var molTextResult = ${molText};
        jsmeApplet.readMolFile(molTextResult);
}
</script>
`;
      domElement.appendChild(iframe);
      iframe.id = "visualizationMolIfrane";
      iframe.contentWindow.document.open();
      iframe.contentWindow.document.write(html);
      iframe.contentWindow.document.close();
      iframe.width = "500px";
      iframe.height = "440px";
      iframe.style.border = "0";
      const x = document.getElementById("visualizationMolIfrane") as any;
      let y = (x.contentWindow || x.contentDocument);
      if (y.document) {
        y = y.document;
      }
      y.body.style.overflow = "hidden";
      y.body.style.height = "404px !important";

    });

    fr.readAsText(fileInfo.blob);

  }

  doAction(fileInfo: FileInput, domElement: Element): void {

  }

  isZoomSupported(): boolean {
    return false;
  }

  handleZoom(zoomEnable: boolean, fileInfo: FileInput, domElement: Element): void {
  }

  isFullScreenSupported(): boolean {
    return true;
  }
}
