import {
  ComponentFactoryResolver,
  Injectable,
  NgZone,
  SimpleChange,
} from "@angular/core";
import {DomSanitizer} from "@angular/platform-browser";
import {environment} from "@environments/environment";
import {AddExternalComponentDirective} from "@shared/filevisualizer/directives/add-external-component.directive";
import {FileInput} from "@shared/filevisualizer/models/file-info.model";
import {AbstractFileVisualizer} from "@shared/filevisualizer/services/abstract-file-visualizer.service";
import {NgxDocViewerComponent} from "ngx-doc-viewer";
import {isTruthyObject} from "solidify-frontend";

// TODO reactivate this plugin when  find a way to transform blob url to public url...

@Injectable()
export class Ng2XsViewerVisualizerService extends AbstractFileVisualizer {

  type: string = "ng2XsPlugin";

  constructor(private readonly componentFactoryResolver: ComponentFactoryResolver,
              private readonly _ngZone: NgZone,
              private readonly _domSanitizer: DomSanitizer) {
    super();
  }

  canHandle(fileInfo: FileInput): boolean {
    if (!isTruthyObject(fileInfo)) {
      return false;
    } else {
      return this.canHandleByExtension(fileInfo) || this.canHandleByMimeTypeContentType(fileInfo) || this.canHandleByPuid(fileInfo);
    }
  }

  canHandleByExtension(fileInfo: FileInput): boolean {
    if (!isTruthyObject(fileInfo)) {
      return false;
    } else {
      return environment.visualizationNg2XsViewerExtensions.some(value => value === fileInfo.fileExtension);
    }
  }

  canHandleWithSize(fileInfo: FileInput): boolean {
    if (!isTruthyObject(fileInfo)) {
      return false;
    } else {
      return fileInfo.dataFile.fileSize <= environment.visualizationMaxSizeFile;
    }
  }

  canHandleByMimeTypeContentType(fileInfo: FileInput): boolean {
    if (!isTruthyObject(fileInfo)) {
      return false;
    } else {
      return environment.visualizationNg2XsViewerContentType.some(value => value === fileInfo.dataFile.fileFormat?.contentType) || environment.visualizationNg2XsViewerMimeType.some(value => value === fileInfo.dataFile.fileFormat.contentType);
    }
  }

  isVisualizationOnGoing(fileInfo: FileInput, domElement: Element): boolean {
    return false;
  }

  canHandleByPuid(fileInfo: FileInput): boolean {
    if (!isTruthyObject(fileInfo)) {
      return false;
    } else {
      return environment.visualizationNg2XsViewerPronomId.some(value => value === fileInfo.dataFile.fileFormat.puid);
    }
  }

  closeVisualizer(fileInfo: FileInput, domElement: Element): void {
    domElement.remove();
  }

  private isPdfFile(): boolean {
    // TODO
    return false;
  }

  private isOfficeFile(): boolean {
    // TODO
    return false;
  }

  private isotherFIle(): boolean {
    // TODO
    return false;
  }

  base64Data: string;

  openVisualizer(fileInfo: FileInput, domElement: Element, addExternalPlugin?: AddExternalComponentDirective): void {
    if (this.canHandle(fileInfo)) {
      const componentFactory = this.componentFactoryResolver.resolveComponentFactory(NgxDocViewerComponent);
      const addExternalPluginContainerRef = addExternalPlugin.viewContainerRef;
      addExternalPluginContainerRef.clear();
      const componentRef = addExternalPluginContainerRef.createComponent(componentFactory);
      //const url = URL.createObjectURL(fileInfo.blob);
      //const url = URL.createObjectURL(fileInfo.blob);
      //const url = "https://file-examples.com/wp-content/uploads/2017/02/file-sample_100kB.docx";
      //const url = window.URL.createObjectURL(fileInfo.blob);
      //console.log(url);
      //const reader = new FileReader();
      // reader.readAsDataURL(fileInfo.blob);
      const reader = new FileReader();
      reader.readAsDataURL(fileInfo.blob);
      reader.onloadend = () => {
        this.base64Data = reader.result as string;
        //const url = this.base64Data.replace("application/octet-stream", fileInfo.dataFile.fileFormat.contentType);
        //console.log(url);
        const url = this.base64Data;
        // todo change
        //const url = URL.createObjectURL(fileInfo.blob);
        const ng2XsViewerComponent = componentRef.instance as NgxDocViewerComponent;
        const isFirstChange = true;
        const simpleChanges = {} as any;
        const urlSimpleChange = new SimpleChange(ng2XsViewerComponent.url, url, isFirstChange);
        ng2XsViewerComponent.url = url;
        simpleChanges.url = urlSimpleChange;
        const viewer = "google";
        const viewerSimpleChange = new SimpleChange(ng2XsViewerComponent.viewer, viewer, isFirstChange);
        ng2XsViewerComponent.viewer = viewer;
        simpleChanges.viewer = viewerSimpleChange;
        ng2XsViewerComponent.fullUrl = this._domSanitizer.bypassSecurityTrustResourceUrl(url);
        ng2XsViewerComponent.externalViewer = false;
        ng2XsViewerComponent.googleCheckInterval = 10;
        ng2XsViewerComponent.googleCheckContentLoaded = true;
        ng2XsViewerComponent.ngOnChanges(simpleChanges);
        componentRef.changeDetectorRef.detectChanges();
      };
    }
  }

  doAction(fileInfo: FileInput, fileInfo: FileInput, domElement: Element): void {
  }

  isZoomSupported(): boolean {
    return false;
  }

  isFullScreenSupported(): boolean {
    return false;
  }

}
