import {InjectionToken} from "@angular/core";
import {AddExternalComponentDirective} from "@shared/filevisualizer/directives/add-external-component.directive";
import {FileInput} from "@shared/filevisualizer/models/file-info.model";

export const FILE_VISUALIZERS = new InjectionToken<AbstractFileVisualizer[]>("fileVisualizers");

export abstract class AbstractFileVisualizer {

  abstract type: string;

  abstract canHandle(fileInfo: FileInput): boolean;

  abstract openVisualizer(fileInfo: FileInput, domElement: Element, addExternalPlugin?: AddExternalComponentDirective): void;

  abstract closeVisualizer(fileInfo: FileInput, domElement: Element): void;

  abstract canHandleByExtension(fileInfo: FileInput): boolean;

  abstract canHandleByMimeTypeContentType(fileInfo: FileInput): boolean;

  abstract canHandleByPuid(fileInfo: FileInput): boolean;

  abstract canHandleWithSize(fileInfo: FileInput): boolean;

  abstract isVisualizationOnGoing(fileInfo: FileInput, domElement: Element): boolean;

  abstract doAction(fileInfo: FileInput, domElement: Element): void;

  abstract isZoomSupported(): boolean;

  abstract isFullScreenSupported(): boolean;

  abstract handleZoom(zoomEnable: boolean, fileInfo: FileInput, domElement: Element): void;

}
