import {
  Component,
  Input,
  Output,
} from "@angular/core";
import {SharedAbstractPresentational} from "@shared/components/presentationals/shared-abstract/shared-abstract.presentational";
import {
  BehaviorSubject,
  Observable,
} from "rxjs";
import {ObservableUtil} from "solidify-frontend";

@Component({
  selector: "dlcm-pdf-with-tool-bar",
  templateUrl: "./pdf-viewer-with-tool-bar.component.html",
  styleUrls: ["./pdf-viewer-with-tool-bar.component.scss"],
})
export class PdfViewerWithToolBarPresentational extends SharedAbstractPresentational {

  @Input()
  zoom: number;

  private readonly _zoomBS: BehaviorSubject<number | undefined> = new BehaviorSubject<number | undefined>(undefined);
  @Output("zoomChange")
  readonly zoomObs: Observable<number | undefined> = ObservableUtil.asObservable(this._zoomBS);

  incrementZoom(zoomNumber: number): void {
    this.zoom += zoomNumber;
    if (this.zoom <= 0) {
      this.zoom = 0;
    }
    this._zoomBS.next(this.zoom);
  }

}
