import {Enums} from "@enums";
import {FileInput} from "@shared/filevisualizer/models/file-info.model";
import {AbstractFileVisualizer} from "@shared/filevisualizer/services/abstract-file-visualizer.service";
import {
  isTruthyObject,
  MARK_AS_TRANSLATABLE,
} from "solidify-frontend";

export class FileVisualizerHelper {
  static canHandle(fileVisualizers: AbstractFileVisualizer[], fileInfo: FileInput): boolean {
    if (!isTruthyObject(fileInfo)) {
      return false;
    }
    if (fileInfo.dataFile.status !== Enums.DataFile.StatusEnum.READY) {
      return false;
    }
    return fileVisualizers.some(value => {
      const computeCanHandleSize = value.canHandleWithSize(fileInfo);
      const computeCanHandle = value.canHandle(fileInfo);
      return computeCanHandleSize && computeCanHandle;
    });
  }

  static errorMessage(fileVisualizers: AbstractFileVisualizer[], fileInfo: FileInput): string {
    if (!fileVisualizers.every(value => value.canHandleWithSize(fileInfo) && value.canHandle(fileInfo))) {
      return this.cannotHandleErrorMessage(fileVisualizers[0], fileInfo);
    }
  }

  static getFileExtension(fileName: string): string {
    return fileName?.split(".").pop();
  }

  static cannotHandleErrorMessage(fileVisualizers: AbstractFileVisualizer, fileInfo: FileInput): string {
    if (!fileVisualizers.canHandleByExtension(fileInfo)) {
      return MARK_AS_TRANSLATABLE("notification.file.visualizer.file.notSupported");
    } else if (!fileVisualizers.canHandleByMimeTypeContentType(fileInfo)) {
      return MARK_AS_TRANSLATABLE("notification.file.visualizer.file.contentTypeNotSupported");
    } else if (!fileVisualizers.canHandleWithSize(fileInfo)) {
      return MARK_AS_TRANSLATABLE("notification.file.visualizer.file.tooBig");
    }
    return "";
  }
}
