import {Injectable} from "@angular/core";
import {Aip} from "@models";

import {
  Actions,
  State,
  Store,
} from "@ngxs/store";
import {LocalStateEnum} from "@shared/enums/local-state.enum";
import {AipHelper} from "@shared/features/aip/helpers/aip.helper";
import {sharedAipStatusHistoryNamespace} from "@shared/features/aip/stores/status-history/shared-aip-status-history.action";
import {
  defaultStatusHistoryInitValue,
  StatusHistoryState,
  StatusHistoryStateModel,
} from "@shared/stores/status-history/status-history.state";
import {
  ApiService,
  NotificationService,
} from "solidify-frontend";

export interface SharedAipStatusHistoryStateModel extends StatusHistoryStateModel<Aip> {
}

@Injectable()
@State<SharedAipStatusHistoryStateModel>({
  name: LocalStateEnum.shared_aip_statusHistory,
  defaults: {
    ...defaultStatusHistoryInitValue(),
  },
})
export class SharedAipStatusHistoryState extends StatusHistoryState<SharedAipStatusHistoryStateModel, Aip> {

  constructor(protected apiService: ApiService,
              protected store: Store,
              protected notificationService: NotificationService,
              protected actions$: Actions) {
    super(apiService, store, notificationService, actions$, {
      nameSpace: sharedAipStatusHistoryNamespace,
    });
  }

  protected get _urlResource(): string {
    return AipHelper.generateUrlResource(this.store);
  }
}
