import {Aip} from "@models";
import {LocalStateEnum} from "@shared/enums/local-state.enum";
import {
  BaseAction,
  BaseSubAction,
  ResourceAction,
  ResourceNameSpace,
  TypeDefaultAction,
} from "solidify-frontend";

const state = LocalStateEnum.shared_aip;

export namespace SharedAipAction {
  @TypeDefaultAction(state)
  export class LoadResource extends ResourceAction.LoadResource {
  }

  @TypeDefaultAction(state)
  export class LoadResourceSuccess extends ResourceAction.LoadResourceSuccess {
  }

  @TypeDefaultAction(state)
  export class LoadResourceFail extends ResourceAction.LoadResourceFail {
  }

  @TypeDefaultAction(state)
  export class ChangeQueryParameters extends ResourceAction.ChangeQueryParameters {
  }

  @TypeDefaultAction(state)
  export class GetAll extends ResourceAction.GetAll {
  }

  @TypeDefaultAction(state)
  export class GetAllSuccess extends ResourceAction.GetAllSuccess<Aip> {
  }

  @TypeDefaultAction(state)
  export class GetAllFail extends ResourceAction.GetAllFail<Aip> {
  }

  @TypeDefaultAction(state)
  export class GetByListId extends ResourceAction.GetByListId {
  }

  @TypeDefaultAction(state)
  export class GetByListIdSuccess extends ResourceAction.GetByListIdSuccess {
  }

  @TypeDefaultAction(state)
  export class GetByListIdFail extends ResourceAction.GetByListIdFail {
  }

  @TypeDefaultAction(state)
  export class GetById extends ResourceAction.GetById {
    constructor(public id: string, public keepCurrentContext: boolean = false, public addInListTemp: boolean = false, public storagionNumber: number | undefined = undefined, public url: string | undefined = undefined) {
      super(id, keepCurrentContext, addInListTemp);
    }
  }

  @TypeDefaultAction(state)
  export class GetByIdSuccess extends ResourceAction.GetByIdSuccess<Aip> {
  }

  @TypeDefaultAction(state)
  export class GetByIdFail extends ResourceAction.GetByIdFail<Aip> {
  }

  @TypeDefaultAction(state)
  export class Create extends ResourceAction.Create<Aip> {
  }

  @TypeDefaultAction(state)
  export class CreateSuccess extends ResourceAction.CreateSuccess<Aip> {
  }

  @TypeDefaultAction(state)
  export class CreateFail extends ResourceAction.CreateFail<Aip> {
  }

  @TypeDefaultAction(state)
  export class Update extends ResourceAction.Update<Aip> {
  }

  @TypeDefaultAction(state)
  export class UpdateSuccess extends ResourceAction.UpdateSuccess<Aip> {
  }

  @TypeDefaultAction(state)
  export class UpdateFail extends ResourceAction.UpdateFail<Aip> {
  }

  @TypeDefaultAction(state)
  export class Delete extends ResourceAction.Delete {
  }

  @TypeDefaultAction(state)
  export class DeleteSuccess extends ResourceAction.DeleteSuccess {
  }

  @TypeDefaultAction(state)
  export class DeleteFail extends ResourceAction.DeleteFail {
  }

  @TypeDefaultAction(state)
  export class AddInList extends ResourceAction.AddInList<Aip> {
  }

  @TypeDefaultAction(state)
  export class AddInListById extends ResourceAction.AddInListById {
  }

  @TypeDefaultAction(state)
  export class AddInListByIdSuccess extends ResourceAction.AddInListByIdSuccess<Aip> {
  }

  @TypeDefaultAction(state)
  export class AddInListByIdFail extends ResourceAction.AddInListByIdFail<Aip> {
  }

  @TypeDefaultAction(state)
  export class RemoveInListById extends ResourceAction.RemoveInListById {
  }

  @TypeDefaultAction(state)
  export class RemoveInListByListId extends ResourceAction.RemoveInListByListId {
  }

  @TypeDefaultAction(state)
  export class LoadNextChunkList extends ResourceAction.LoadNextChunkList {
  }

  @TypeDefaultAction(state)
  export class LoadNextChunkListSuccess extends ResourceAction.LoadNextChunkListSuccess<Aip> {
  }

  @TypeDefaultAction(state)
  export class LoadNextChunkListFail extends ResourceAction.LoadNextChunkListFail {
  }

  @TypeDefaultAction(state)
  export class Clean extends ResourceAction.Clean {
  }

  export class Download {
    static readonly type: string = `[${state}] Download`;

    constructor(public id: string) {
    }
  }

  export class SimpleChecksum extends BaseAction {
    static readonly type: string = `[${state}] Simple Checksums`;

    constructor(public id: string) {
      super();
    }
  }

  export class SimpleChecksumSuccess extends BaseSubAction<SimpleChecksum> {
    static readonly type: string = `[${state}] SimpleChecksum Success`;
  }

  export class SimpleChecksumFail extends BaseSubAction<SimpleChecksum> {
    static readonly type: string = `[${state}] SimpleChecksum Fail`;
  }

  export class DeepChecksum extends BaseAction {
    static readonly type: string = `[${state}] Deep Checksums`;

    constructor(public id: string) {
      super();
    }
  }

  export class DeepChecksumSuccess extends BaseSubAction<DeepChecksum> {
    static readonly type: string = `[${state}] DeepChecksum Success`;
  }

  export class DeepChecksumFail extends BaseSubAction<DeepChecksum> {
    static readonly type: string = `[${state}] DeepChecksum Fail`;
  }

  export class Reindex extends BaseAction {
    static readonly type: string = `[${state}] Reindex`;

    constructor(public id: string) {
      super();
    }
  }

  export class ReindexSuccess extends BaseSubAction<Reindex> {
    static readonly type: string = `[${state}] Reindex Success`;
  }

  export class ReindexFail extends BaseSubAction<Reindex> {
    static readonly type: string = `[${state}] Reindex Fail`;
  }

  export class Check extends BaseAction {
    static readonly type: string = `[${state}] Check`;

    constructor(public id: string) {
      super();
    }
  }

  export class CheckSuccess extends BaseSubAction<Check> {
    static readonly type: string = `[${state}] Check Success`;
  }

  export class CheckFail extends BaseSubAction<Check> {
    static readonly type: string = `[${state}] Check Fail`;
  }

  export class Dispose extends BaseAction {
    static readonly type: string = `[${state}] Dispose`;

    constructor(public id: string) {
      super();
    }
  }

  export class DisposeSuccess extends BaseSubAction<Dispose> {
    static readonly type: string = `[${state}] Dispose Success`;
  }

  export class DisposeFail extends BaseSubAction<Dispose> {
    static readonly type: string = `[${state}] Dispose Fail`;
  }

  export class ApproveDisposal extends BaseAction {
    static readonly type: string = `[${state}] Approve Disposal`;

    constructor(public id: string, public reason: string) {
      super();
    }
  }

  export class ApproveDisposalSuccess extends BaseSubAction<ApproveDisposal> {
    static readonly type: string = `[${state}] Approve Disposal Success`;
  }

  export class ApproveDisposalFail extends BaseSubAction<ApproveDisposal> {
    static readonly type: string = `[${state}] Approve Disposal Fail`;
  }

  export class ApproveDisposalByOrgunit extends BaseAction {
    static readonly type: string = `[${state}] Approve Disposal By Orgunit`;

    constructor(public id: string, public reason: string) {
      super();
    }
  }

  export class ApproveDisposalByOrgunitSuccess extends BaseSubAction<ApproveDisposalByOrgunit> {
    static readonly type: string = `[${state}] Approve Disposal By Orgunit Success`;
  }

  export class ApproveDisposalByOrgunitFail extends BaseSubAction<ApproveDisposalByOrgunit> {
    static readonly type: string = `[${state}] Approve Disposal By Orgunit Fail`;
  }

  export class ExtendRetention extends BaseAction {
    static readonly type: string = `[${state}] Extend Retention`;

    constructor(public id: string, public duration: number) {
      super();
    }
  }

  export class ExtendRetentionSuccess extends BaseSubAction<ExtendRetention> {
    static readonly type: string = `[${state}] Extend Retention Success`;
  }

  export class ExtendRetentionFail extends BaseSubAction<ExtendRetention> {
    static readonly type: string = `[${state}] Extend Retention Fail`;
  }

  export class Resume extends BaseAction {
    static readonly type: string = `[${state}] Resume`;

    constructor(public id: string) {
      super();
    }
  }

  export class ResumeSuccess extends BaseSubAction<Resume> {
    static readonly type: string = `[${state}] Resume Success`;
  }

  export class ResumeFail extends BaseSubAction<Resume> {
    static readonly type: string = `[${state}] Resume Fail`;
  }

  export class GoToAip extends BaseAction {
    static readonly type: string = `[${state}] GoToAip`;

    constructor(public aip: Aip, public storagion_number: string) {
      super();
    }
  }
}

export const sharedAipActionNameSpace: ResourceNameSpace = SharedAipAction;
