import {Injectable} from "@angular/core";
import {environment} from "@environments/environment";
import {AccessOrganizationalUnit} from "@models";
import {
  Actions,
  State,
  Store,
} from "@ngxs/store";
import {AdminResourceApiEnum} from "@shared/enums/api.enum";
import {LocalStateEnum} from "@shared/enums/local-state.enum";
import {sharedAipOrgUnitActionNameSpace} from "@shared/features/aip/stores/organizational-unit/shared-aip-organizational-unit.action";
import {
  ApiService,
  defaultResourceStateInitValue,
  NotificationService,
  QueryParameters,
  ResourceState,
  ResourceStateModel,
} from "solidify-frontend";

export const defaultSharedAipOrgUnitValue: () => SharedAipOrganizationalUnitStateModel = () =>
  ({
    ...defaultResourceStateInitValue(),
    queryParameters: new QueryParameters(environment.defaultPageSize),
    search: null,
  });

export interface SharedAipOrganizationalUnitStateModel extends ResourceStateModel<AccessOrganizationalUnit> {
  search: string;
}

@Injectable()
@State<SharedAipOrganizationalUnitStateModel>({
  name: LocalStateEnum.shared_aip_organizationalUnit,
  defaults: {
    ...defaultSharedAipOrgUnitValue(),
  },
})
export class SharedAipOrganizationalUnitState extends ResourceState<SharedAipOrganizationalUnitStateModel, AccessOrganizationalUnit> {

  constructor(protected apiService: ApiService,
              protected store: Store,
              protected notificationService: NotificationService,
              protected actions$: Actions) {
    super(apiService, store, notificationService, actions$, {
      nameSpace: sharedAipOrgUnitActionNameSpace,
    });
  }

  protected get _urlResource(): string {
    return AdminResourceApiEnum.organizationalUnits;
  }

}
