import {Injectable} from "@angular/core";

import {
  Actions,
  State,
  Store,
} from "@ngxs/store";
import {LocalStateEnum} from "@shared/enums/local-state.enum";
import {AipHelper} from "@shared/features/aip/helpers/aip.helper";
import {AipDataFile} from "@shared/features/aip/models/aip-data-file.model";
import {sharedAipDataFileStatusHistoryNamespace} from "@shared/features/aip/stores/aip-data-file/status-history/shared-aip-data-file-status-history.action";
import {
  defaultStatusHistoryInitValue,
  StatusHistoryState,
  StatusHistoryStateModel,
} from "@shared/stores/status-history/status-history.state";
import {
  ApiService,
  NotificationService,
} from "solidify-frontend";

export interface SharedAipDataFileStatusHistoryStateModel extends StatusHistoryStateModel<AipDataFile> {
}

@Injectable()
@State<SharedAipDataFileStatusHistoryStateModel>({
  name: LocalStateEnum.shared_aip_dataFile_statusHistory,
  defaults: {
    ...defaultStatusHistoryInitValue(),
  },
})
export class SharedAipDataFileStatusHistoryState extends StatusHistoryState<SharedAipDataFileStatusHistoryStateModel, AipDataFile> {

  constructor(protected apiService: ApiService,
              protected store: Store,
              protected notificationService: NotificationService,
              protected actions$: Actions) {
    super(apiService, store, notificationService, actions$, {
      nameSpace: sharedAipDataFileStatusHistoryNamespace,
    });
  }

  protected get _urlResource(): string {
    return AipHelper.generateUrlResourceHistoryDataFile(this.store);
  }
}
