import {LocalStateEnum} from "@shared/enums/local-state.enum";
import {StatusHistoryNamespace} from "@shared/stores/status-history/status-history-namespace.model";
import {StatusHistoryAction} from "@shared/stores/status-history/status-history.action";
import {TypeDefaultAction} from "solidify-frontend";

const state = LocalStateEnum.shared_aip_dataFile_statusHistory;

export namespace SharedAipDataFileStatusHistoryAction {

  @TypeDefaultAction(state)
  export class History extends StatusHistoryAction.History {
  }

  @TypeDefaultAction(state)
  export class HistorySuccess extends StatusHistoryAction.HistorySuccess {
  }

  @TypeDefaultAction(state)
  export class HistoryFail extends StatusHistoryAction.HistoryFail {
  }

  @TypeDefaultAction(state)
  export class ChangeQueryParameters extends StatusHistoryAction.ChangeQueryParameters {
  }
}

export const sharedAipDataFileStatusHistoryNamespace: StatusHistoryNamespace = SharedAipDataFileStatusHistoryAction;
