import {Injectable} from "@angular/core";
import {Aip} from "@models";

import {
  Actions,
  State,
  Store,
} from "@ngxs/store";
import {LocalStateEnum} from "@shared/enums/local-state.enum";
import {AipHelper} from "@shared/features/aip/helpers/aip.helper";
import {sharedAipCollectionStatusHistoryNamespace} from "@shared/features/aip/stores/aip-collection/status-history/shared-aip-collection-status-history.action";
import {
  defaultStatusHistoryInitValue,
  StatusHistoryState,
  StatusHistoryStateModel,
} from "@shared/stores/status-history/status-history.state";
import {
  ApiService,
  NotificationService,
} from "solidify-frontend";

export interface SharedAipCollectionStatusHistoryStateModel extends StatusHistoryStateModel<Aip> {
}

@Injectable()
@State<SharedAipCollectionStatusHistoryStateModel>({
  name: LocalStateEnum.shared_aip_collection_statusHistory,
  defaults: {
    ...defaultStatusHistoryInitValue(),
  },
})
export class SharedAipCollectionStatusHistoryState extends StatusHistoryState<SharedAipCollectionStatusHistoryStateModel, Aip> {

  constructor(protected apiService: ApiService,
              protected store: Store,
              protected notificationService: NotificationService,
              protected actions$: Actions) {
    super(apiService, store, notificationService, actions$, {
      nameSpace: sharedAipCollectionStatusHistoryNamespace,
    });
  }

  protected get _urlResource(): string {
    return AipHelper.generateUrlResource(this.store);
  }
}
