import {Aip} from "@models";
import {LocalStateEnum} from "@shared/enums/local-state.enum";
import {AipDataFile} from "@shared/features/aip/models/aip-data-file.model";
import {
  CompositionAction,
  CompositionNameSpace,
  TypeDefaultAction,
} from "solidify-frontend";

const state = LocalStateEnum.shared_aip_collection;

export namespace SharedAipCollectionAction {
  @TypeDefaultAction(state)
  export class GetAll extends CompositionAction.GetAll {
  }

  @TypeDefaultAction(state)
  export class GetAllSuccess extends CompositionAction.GetAllSuccess<AipDataFile> {
  }

  @TypeDefaultAction(state)
  export class GetAllFail extends CompositionAction.GetAllFail {
  }

  @TypeDefaultAction(state)
  export class GetById extends CompositionAction.GetById {
  }

  @TypeDefaultAction(state)
  export class GetByIdSuccess extends CompositionAction.GetByIdSuccess<Aip> {
  }

  @TypeDefaultAction(state)
  export class GetByIdFail extends CompositionAction.GetByIdFail {
  }

  @TypeDefaultAction(state)
  export class Update extends CompositionAction.Update<AipDataFile> {
  }

  @TypeDefaultAction(state)
  export class UpdateSuccess extends CompositionAction.UpdateSuccess<Aip> {
  }

  @TypeDefaultAction(state)
  export class UpdateFail extends CompositionAction.UpdateFail<Aip> {
  }

  @TypeDefaultAction(state)
  export class Create extends CompositionAction.Create<Aip> {
  }

  @TypeDefaultAction(state)
  export class CreateSuccess extends CompositionAction.CreateSuccess<Aip> {
  }

  @TypeDefaultAction(state)
  export class CreateFail extends CompositionAction.CreateFail<Aip> {
  }

  @TypeDefaultAction(state)
  export class Delete extends CompositionAction.Delete {
  }

  @TypeDefaultAction(state)
  export class DeleteSuccess extends CompositionAction.DeleteSuccess {
  }

  @TypeDefaultAction(state)
  export class DeleteFail extends CompositionAction.DeleteFail {
  }

  @TypeDefaultAction(state)
  export class ChangeQueryParameters extends CompositionAction.ChangeQueryParameters {
  }

  export class DownloadAip {
    static readonly type: string = `[${state}] Download Aip`;

    constructor(public parentId: string, public aip: Aip) {
    }
  }

  export class Refresh {
    static readonly type: string = `[${state}] Refresh`;

    constructor(public parentId: string) {
    }
  }

  export class GoToAip {
    static readonly type: string = `[${state}] Go To Aip`;

    constructor(public aip: Aip, public storagion_number: string) {
    }
  }
}

export const sharedAipCollectionActionNameSpace: CompositionNameSpace = SharedAipCollectionAction;
