import {
  ChangeDetectionStrategy,
  Component,
  OnInit,
} from "@angular/core";
import {
  ActivatedRoute,
  Router,
} from "@angular/router";
import {Store} from "@ngxs/store";
import {Tab} from "@shared/components/containers/shared-tabs/shared-tabs.container";
import {SharedAbstractRoutable} from "@shared/components/routables/shared-abstract/shared-abstract.routable";
import {IconNameEnum} from "@shared/enums/icon-name.enum";
import {LabelTranslateEnum} from "@shared/enums/label-translate.enum";
import {
  PreservationPlanningRoutesEnum,
  RoutesEnum,
  SharedAipRoutesEnum,
} from "@shared/enums/routes.enum";
import {
  AipHelper,
  AipMode,
} from "@shared/features/aip/helpers/aip.helper";

@Component({
  selector: "dlcm-shared-aip-tabs-list-routable",
  templateUrl: "./shared-aip-tabs.routable.html",
  styleUrls: ["./shared-aip-tabs.routable.scss"],
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class SharedAipTabsRoutable extends SharedAbstractRoutable implements OnInit {
  private storagionNode: number | undefined = undefined;
  private currentTab: Tab;

  mode: AipMode;

  constructor(protected readonly _store: Store,
              protected readonly _route: ActivatedRoute,
              protected readonly _router: Router) {
    super();
  }

  ngOnInit(): void {
    this.mode = AipHelper.determineMode(this._store);
    if (this.mode === AipMode.AIP) {
      this.storagionNode = +this._route.snapshot.parent.paramMap.get(PreservationPlanningRoutesEnum.storagionNumberWithoutPrefixParam);
    }
  }

  private get rootUrl(): string[] {
    switch (this.mode) {
      case AipMode.AIP:
        return [RoutesEnum.preservationPlanningAip, this.storagionNode + "", SharedAipRoutesEnum.aipList];
      case AipMode.AIP_STEWARD:
        return [RoutesEnum.preservationSpaceAipStewardList];
      case AipMode.DOWNLOADED_AIP:
        return [RoutesEnum.preservationPlanningAipDownloadedList];
    }
    return [];
  }

  listTabs: Tab[] = [
    {
      id: TabEnum.ALL_TAB_INDEX,
      suffixUrl: SharedAipRoutesEnum.aipTabAll,
      icon: IconNameEnum.metadata,
      titleToTranslate: LabelTranslateEnum.all,
      route: () => [...this.rootUrl, SharedAipRoutesEnum.aipTabAll],
    },
    {
      id: TabEnum.UNIT_TAB_INDEX,
      suffixUrl: SharedAipRoutesEnum.aipTabUnit,
      icon: IconNameEnum.files,
      titleToTranslate: LabelTranslateEnum.units,
      route: () => [...this.rootUrl, SharedAipRoutesEnum.aipTabUnit],
    },
    {
      id: TabEnum.COLLECTION_TAB_INDEX,
      suffixUrl: SharedAipRoutesEnum.aipTabCollections,
      icon: IconNameEnum.collection,
      titleToTranslate: LabelTranslateEnum.collection,
      route: () => [...this.rootUrl, SharedAipRoutesEnum.aipTabCollections],
    },
  ];

  setCurrentTab($event: Tab): void {
    this.currentTab = $event;
  }
}

enum TabEnum {
  ALL_TAB_INDEX = "ALL_TAB_INDEX",
  UNIT_TAB_INDEX = "UNIT_TAB_INDEX",
  COLLECTION_TAB_INDEX = "COLLECTION_TAB_INDEX",
}
