import {
  ChangeDetectionStrategy,
  ChangeDetectorRef,
  Component,
  OnDestroy,
  OnInit,
  ViewChild,
} from "@angular/core";
import {MatDialog} from "@angular/material/dialog";
import {ActivatedRoute} from "@angular/router";
import {Aip} from "@models";
import {
  Actions,
  Select,
  Store,
} from "@ngxs/store";
import {SharedAbstractDetailEditRoutable} from "@shared/components/routables/shared-abstract-detail-edit/shared-abstract-detail-edit.routable";
import {LocalStateEnum} from "@shared/enums/local-state.enum";
import {SharedAipFormPresentational} from "@shared/features/aip/components/presentationals/aip-form/shared-aip-form.presentational";
import {
  AipHelper,
  AipMode,
} from "@shared/features/aip/helpers/aip.helper";
import {sharedAipActionNameSpace} from "@shared/features/aip/stores/shared-aip.action";
import {
  SharedAipState,
  SharedAipStateModel,
} from "@shared/features/aip/stores/shared-aip.state";
import {Observable} from "rxjs";

@Component({
  selector: "dlcm-shared-aip-metadata-routable",
  templateUrl: "./shared-aip-metadata.routable.html",
  styleUrls: ["./shared-aip-metadata.routable.scss"],
  changeDetection: ChangeDetectionStrategy.OnPush,
})

export class SharedAipMetadataRoutable extends SharedAbstractDetailEditRoutable<Aip, SharedAipStateModel> implements OnInit, OnDestroy {
  @Select(SharedAipState.isLoadingWithDependency) isLoadingWithDependencyObs: Observable<boolean>;
  @Select(SharedAipState.isReadyToBeDisplayed) isReadyToBeDisplayedObs: Observable<boolean>;

  @ViewChild("formPresentational")
  readonly formPresentational: SharedAipFormPresentational;
  mode: AipMode;

  readonly KEY_PARAM_NAME: keyof Aip & string = undefined;

  constructor(protected readonly _store: Store,
              protected readonly _route: ActivatedRoute,
              protected readonly _actions$: Actions,
              protected readonly _changeDetector: ChangeDetectorRef,
              protected readonly _dialog: MatDialog) {
    super(_store, _route, _actions$, _changeDetector, _dialog, LocalStateEnum.shared_aip, sharedAipActionNameSpace, LocalStateEnum.shared);
  }

  ngOnInit(): void {
    super.ngOnInit();
    this.mode = AipHelper.determineMode(this._store);
  }

  ngOnDestroy(): void {
    super.ngOnDestroy();
  }

  protected getSubResourceWithParentId(id: string): void {
  }
}
