import {
  ChangeDetectorRef,
  Component,
  OnInit,
} from "@angular/core";
import {MatDialog} from "@angular/material/dialog";
import {ActivatedRoute} from "@angular/router";
import {Aip} from "@models";
import {
  Actions,
  Store,
} from "@ngxs/store";
import {SharedAbstractFileAipDetailRoutable} from "@shared/components/routables/shared-abstract-file-aip-detail/shared-abstract-file-aip-detail.routable";
import {PreservationPlanningRoutesEnum} from "@shared/enums/routes.enum";
import {
  SharedAipCollectionAction,
  sharedAipCollectionActionNameSpace,
} from "@shared/features/aip/stores/aip-collection/shared-aip-collection.action";
import {SharedAipCollectionState} from "@shared/features/aip/stores/aip-collection/shared-aip-collection.state";
import {sharedAipCollectionStatusHistoryNamespace} from "@shared/features/aip/stores/aip-collection/status-history/shared-aip-collection-status-history.action";
import {SharedAipCollectionStatusHistoryState} from "@shared/features/aip/stores/aip-collection/status-history/shared-aip-collection-status-history.state";
import {Override} from "solidify-frontend";

@Component({
  selector: "dlcm-shared-aip-collection-detail",
  templateUrl: "../../../../../../shared/components/routables/shared-abstract-file-aip-detail/shared-abstract-file-aip-detail.routable.html",
  styleUrls: ["../../../../../../shared/components/routables/shared-abstract-file-aip-detail/shared-abstract-file-aip-detail.routable.scss"],
})
export class SharedAipCollectionDetailRoutable extends SharedAbstractFileAipDetailRoutable<Aip> implements OnInit {
  constructor(protected readonly _store: Store,
              protected readonly _route: ActivatedRoute,
              protected readonly _actions$: Actions,
              protected readonly _dialog: MatDialog,
              protected readonly _changeDetector: ChangeDetectorRef) {
    super(_store,
      _route,
      _actions$,
      _dialog,
      _changeDetector,
      SharedAipCollectionState,
      sharedAipCollectionActionNameSpace,
      SharedAipCollectionStatusHistoryState,
      sharedAipCollectionStatusHistoryNamespace);
  }

  @Override()
  protected _goToAip(): void {
    const storagion_number = this._route.snapshot.parent.parent.parent.paramMap.get(PreservationPlanningRoutesEnum.storagionNumberWithoutPrefixParam);
    this._store.dispatch(new SharedAipCollectionAction.GoToAip(this.data.aip, storagion_number));
  }
}
