import {ApiModuleEnum} from "@app/shared/enums/api-module.enum";
import {ApiResourceNameEnum} from "@app/shared/enums/api-resource-name.enum";
import {environment} from "@environments/environment";
import {ApiActionEnum} from "@shared/enums/api-action.enum";
import {AipHelper} from "@shared/features/aip/helpers/aip.helper";
import {Storage} from "@shared/models/storage.model";
import {ResourceApiEnum} from "solidify-frontend";

export class ApiKeyword {
  static PARENT_ID: string = "parentId";
  static SUB_RESOURCE: string = "subResource";
}

export const SEPARATOR: string = "/";
const subResource = `{${ApiKeyword.SUB_RESOURCE}}`;
const parentId = `{${ApiKeyword.PARENT_ID}}`;
const parentIdInUrl = SEPARATOR + parentId + SEPARATOR;
const search = "search";
const api = "api";
const apiInUrl = SEPARATOR + api + SEPARATOR;

export class BaseResourceApiEnum {
  static get access(): string {
    return environment.access;
  }

  static get admin(): string {
    return environment.admin;
  }

  static get dataMgmt(): string {
    return environment.dataManagement;
  }

  static get resourceSrv(): string {
    return environment.admin + SEPARATOR + ApiModuleEnum.RES_SRV;
  }

  static get preservationPlanning(): string {
    const urlAdmin = environment.admin.substring(0, environment.admin.lastIndexOf("/"));
    return urlAdmin + SEPARATOR + ApiModuleEnum.PRES_PLANNING;
  }

  static get ingest(): string {
    return environment.ingest;
  }

  static get preingest(): string {
    return environment.preingest;
  }

  static get archivalStorageDefaultUrl(): string {
    return this.archivalStorageDefault.url;
  }

  static get archivalStorageDefault(): Storage {
    const defaultIndex = environment.defaultStorageIndex;
    if (this.archivalStorageList.length < defaultIndex) {
      return this.archivalStorageList[0];
    }
    return this.archivalStorageList[defaultIndex];
  }

  static get archivalStorageList(): Storage[] {
    const newList: Storage[] = [];
    let index = 1;
    environment.archivalStorage.forEach(url => {
      newList.push({
        index: index,
        url: url,
        name: AipHelper.getStoragionNameByIndex(index),
      });
      index++;
    });
    return newList;
  }

  static get docs(): string {
    const urlAdmin = environment.admin.substring(0, environment.admin.lastIndexOf("/"));
    return urlAdmin + SEPARATOR + ApiModuleEnum.DOCS;
  }
}

export class AccessResourceApiEnum implements ResourceApiEnum {
  static get root(): string {
    return BaseResourceApiEnum.access;
  }

  static get dip(): string {
    return BaseResourceApiEnum.access + SEPARATOR + ApiResourceNameEnum.DIP;
  }

  static get dipDataFile(): string {
    return BaseResourceApiEnum.ingest + SEPARATOR + ApiResourceNameEnum.DIP + parentIdInUrl + ApiResourceNameEnum.DATAFILE;
  }

  static get publicMetadata(): string {
    return BaseResourceApiEnum.access + SEPARATOR + ApiResourceNameEnum.PUBLIC_METADATA;
  }

  static get privateMetadata(): string {
    return BaseResourceApiEnum.access + SEPARATOR + ApiResourceNameEnum.PRIVATE_METADATA;
  }

  static get oaiSets(): string {
    return BaseResourceApiEnum.access + SEPARATOR + ApiResourceNameEnum.OAI_SETS;
  }

  static get orders(): string {
    return BaseResourceApiEnum.access + SEPARATOR + ApiResourceNameEnum.ORDER;
  }

  static get organizationalUnits(): string {
    return BaseResourceApiEnum.access + SEPARATOR + ApiResourceNameEnum.ORG_UNIT;
  }

  static get aipDownloaded(): string {
    return BaseResourceApiEnum.access + SEPARATOR + ApiResourceNameEnum.AIP;
  }

  static get downloadToken(): string {
    return BaseResourceApiEnum.access + SEPARATOR + ApiResourceNameEnum.DOWNLOAD_TOKEN;
  }
}

export class AdminResourceApiEnum implements ResourceApiEnum {
  // Resource
  static get root(): string {
    return BaseResourceApiEnum.admin;
  }

  static get archiveAcl(): string {
    return BaseResourceApiEnum.admin + SEPARATOR + ApiResourceNameEnum.ARCHIVE_ACL;
  }

  static get fundingAgencies(): string {
    return BaseResourceApiEnum.admin + SEPARATOR + ApiResourceNameEnum.FUNDING_AGENCY;
  }

  static get institutions(): string {
    return BaseResourceApiEnum.admin + SEPARATOR + ApiResourceNameEnum.INSTITUTION;
  }

  static get languages(): string {
    return BaseResourceApiEnum.admin + SEPARATOR + ApiResourceNameEnum.LANGUAGE;
  }

  static get licenses(): string {
    return BaseResourceApiEnum.admin + SEPARATOR + ApiResourceNameEnum.LICENSE;
  }

  static get notifications(): string {
    return BaseResourceApiEnum.admin + SEPARATOR + ApiResourceNameEnum.NOTIFICATION;
  }

  static get notificationsInbox(): string {
    return BaseResourceApiEnum.admin + SEPARATOR + ApiResourceNameEnum.NOTIFICATION + SEPARATOR + ApiActionEnum.INBOX;
  }

  static get oauth2Clients(): string {
    return BaseResourceApiEnum.admin + SEPARATOR + ApiResourceNameEnum.OAUTH2_CLIENT;
  }

  static get orcid(): string {
    return BaseResourceApiEnum.admin + SEPARATOR + ApiResourceNameEnum.ORCID;
  }

  static get organizationalUnits(): string {
    return BaseResourceApiEnum.admin + SEPARATOR + ApiResourceNameEnum.ORG_UNIT;
  }

  static get authorizedOrganizationalUnits(): string {
    return BaseResourceApiEnum.admin + SEPARATOR + ApiResourceNameEnum.AUTHORIZED_ORG_UNIT;
  }

  static get people(): string {
    return BaseResourceApiEnum.admin + SEPARATOR + ApiResourceNameEnum.PERSON;
  }

  static get preservationPolicies(): string {
    return BaseResourceApiEnum.admin + SEPARATOR + ApiResourceNameEnum.PRES_POLICY;
  }

  static get roles(): string {
    return BaseResourceApiEnum.admin + SEPARATOR + ApiResourceNameEnum.ROLE;
  }

  static get submissionPolicies(): string {
    return BaseResourceApiEnum.admin + SEPARATOR + ApiResourceNameEnum.SUB_POLICY;
  }

  static get disseminationPolicies(): string {
    return BaseResourceApiEnum.admin + SEPARATOR + ApiResourceNameEnum.DISSEMINATION_POLICY;
  }

  static get researchDomains(): string {
    return BaseResourceApiEnum.admin + SEPARATOR + ApiResourceNameEnum.RESEARCH_DOMAIN;
  }

  static get users(): string {
    return BaseResourceApiEnum.admin + SEPARATOR + ApiResourceNameEnum.USER;
  }

  static get metadataTypes(): string {
    return BaseResourceApiEnum.admin + SEPARATOR + ApiResourceNameEnum.METADATA_TYPE;
  }

  static get systemProperties(): string {
    return BaseResourceApiEnum.admin + SEPARATOR + ApiResourceNameEnum.SYSTEM_PROPERTY;
  }
}

export class ArchivalStorageResourceApiEnum implements ResourceApiEnum {
  static get root(): string {
    return BaseResourceApiEnum.archivalStorageDefaultUrl;
  }

  static get aip(): string {
    return BaseResourceApiEnum.archivalStorageDefaultUrl + SEPARATOR + ApiResourceNameEnum.AIP;
  }

  static get aipStorages(): Storage[] {
    const archivalStorageList = BaseResourceApiEnum.archivalStorageList;
    const newList: Storage[] = [];
    archivalStorageList.forEach(url => {
      newList.push({
        index: url.index,
        url: url.url + SEPARATOR + ApiResourceNameEnum.AIP,
        name: AipHelper.getStoragionNameByIndex(url.index),
      });
    });
    return newList;
  }
}

export class IngestResourceApiEnum implements ResourceApiEnum {
  static get root(): string {
    return BaseResourceApiEnum.ingest;
  }

  static get sip(): string {
    return BaseResourceApiEnum.ingest + SEPARATOR + ApiResourceNameEnum.SIP;
  }

  static get sipDataFile(): string {
    return BaseResourceApiEnum.ingest + SEPARATOR + ApiResourceNameEnum.SIP + parentIdInUrl + ApiResourceNameEnum.DATAFILE;
  }
}

export class PreIngestResourceApiEnum implements ResourceApiEnum {
  static get root(): string {
    return BaseResourceApiEnum.preingest;
  }

  static get deposits(): string {
    return BaseResourceApiEnum.preingest + SEPARATOR + ApiResourceNameEnum.DEPOSIT;
  }

  static get depositDataFile(): string {
    return BaseResourceApiEnum.preingest + SEPARATOR + ApiResourceNameEnum.DEPOSIT + parentIdInUrl + ApiResourceNameEnum.DATAFILE;
  }

  static get contributors(): string {
    return BaseResourceApiEnum.preingest + SEPARATOR + ApiResourceNameEnum.CONTRIBUTOR;
  }
}

export class DataManagementResourceApiEnum implements ResourceApiEnum {
  static get root(): string {
    return BaseResourceApiEnum.dataMgmt;
  }

  static get indexFieldAliases(): string {
    return BaseResourceApiEnum.dataMgmt + SEPARATOR + ApiResourceNameEnum.INDEX_FIELD_ALIASES;
  }
}

export class PreservationPlanningResourceApiEnum implements ResourceApiEnum {
  static get root(): string {
    return BaseResourceApiEnum.preservationPlanning;
  }

  static get preservationJobs(): string {
    return BaseResourceApiEnum.preservationPlanning + SEPARATOR + ApiResourceNameEnum.PRES_JOB;
  }

  static get monitor(): string {
    return BaseResourceApiEnum.preservationPlanning + SEPARATOR + ApiResourceNameEnum.MONITOR;
  }

  static get preservationAipStatuses(): string {
    return BaseResourceApiEnum.preservationPlanning + SEPARATOR + ApiResourceNameEnum.AIP;
  }

}
