import {
  Directive,
  ElementRef,
  HostListener,
} from "@angular/core";
import {SharedAbstractDirective} from "@shared/directives/shared-abstract/shared-abstract.directive";
import {isNotNullNorUndefined} from "solidify-frontend";

@Directive({
  selector: "[dlcmTooltipOnEllipsis]",
})
export class SharedTooltipOnEllipsisDirective extends SharedAbstractDirective {
  private readonly _ELEMENT_TITLE_KEY: string = "title";
  private readonly _TAG_MAT_FORM_FIELD: string = "MAT-FORM-FIELD";
  private readonly _TAG_INPUT: string = "input";
  private readonly _TAG_MAT_SELECT: string = "mat-select";

  constructor(private elementRef: ElementRef) {
    super();
  }

  @HostListener("mouseenter")
  onMouseEnter(): void {
    setTimeout(() => {
      let element;
      let valueTitle;
      const currentElement = this.elementRef.nativeElement;

      if (currentElement.tagName === this._TAG_MAT_FORM_FIELD) {
        element = currentElement.querySelector(this._TAG_MAT_SELECT);
        if (isNotNullNorUndefined(element)) {
          valueTitle = element.textContent;
        } else {
          const list = currentElement.querySelectorAll(this._TAG_INPUT);
          if (list.length > 0) {
            element = list[list.length - 1];
            valueTitle = element.value;
          }
        }
      } else {
        element = currentElement;
        valueTitle = element.textContent;
      }

      if (isNotNullNorUndefined(element)) {
        this._manageTitleAttribute(element, valueTitle);
      }
    }, 100);
  }

  private _manageTitleAttribute(element: any, valueTitle: string): void {
    if (element.offsetWidth < element.scrollWidth) {
      element[this._ELEMENT_TITLE_KEY] = valueTitle;
    } else if (element[this._ELEMENT_TITLE_KEY]) {
      element.removeAttribute(this._ELEMENT_TITLE_KEY);
    }
  }
}
