import {
  ChangeDetectorRef,
  ComponentFactoryResolver,
  Directive,
  ElementRef,
  Input,
  OnInit,
  Renderer2,
  ViewContainerRef,
} from "@angular/core";
import {environment} from "@environments/environment";
import {SharedAbstractSpinnerDirective} from "@shared/directives/shared-abstract-spinner/shared-abstract-spinner.directive";
import {
  isNullOrUndefined,
  isTrue,
} from "solidify-frontend";

@Directive({
  selector: "[dlcmSpinner]",
})
export class SharedSpinnerDirective extends SharedAbstractSpinnerDirective implements OnInit {

  @Input("dlcmSpinner")
  set show(value: boolean) {
    if (isNullOrUndefined(value)) {
      console.warn("dlcmSpinner directive received a null or undefined value");
      value = true;
    }
    this._show = value;
    if (!this._isReady) {
      return;
    }

    if (isTrue(this._show)) {
      this._renderer.appendChild(this._elementRef.nativeElement, this.spinnerWrapper);
    } else {
      this._renderer.removeChild(this._elementRef.nativeElement, this.spinnerWrapper);
    }
  }

  @Input("dlcmSpinnerStrokeWidth")
  strokeWidth: number = environment.defaultSpinnerStrokeWidth;

  @Input("dlcmSpinnerDiameter")
  diameter: number = environment.defaultSpinnerDiameter;

  @Input("dlcmSpinnerWrapperClass")
  spinnerWrapperAdditionalClass: string | undefined = undefined;

  @Input("dlcmSpinnerTop")
  set spinnerTop(value: number | undefined) {
    if (isNullOrUndefined(value) || value === 0) {
      this._renderer.removeStyle(this.spinnerWrapper, "top");
      return;
    }
    this._renderer.setStyle(this.spinnerWrapper, "top", value + "px");
  }

  @Input("dlcmSpinnerHeight")
  set spinnerHeight(value: number | undefined) {
    if (isNullOrUndefined(value) || value === 0) {
      this._renderer.removeStyle(this.spinnerWrapper, "height");
      return;
    }
    this._renderer.setStyle(this.spinnerWrapper, "height", value + "px");
  }

  @Input("dlcmSpinnerMinHeight")
  set spinnerMinHeight(value: number | undefined) {
    if (isNullOrUndefined(value) || value === 0) {
      this._renderer.removeStyle(this.spinnerWrapper, "min-height");
      return;
    }
    this._renderer.setStyle(this.spinnerWrapper, "min-height", value + "px");
  }

  constructor(protected readonly _elementRef: ElementRef,
              protected readonly _renderer: Renderer2,
              protected readonly _viewContainerRef: ViewContainerRef,
              protected readonly _componentFactoryResolver: ComponentFactoryResolver) {
    super(_elementRef, _renderer, _viewContainerRef, _componentFactoryResolver, "spinner-background");
  }

  ngOnInit(): void {
    super.ngOnInit();
  }
}
