import {
  Directive,
  ElementRef,
  HostListener,
  Input,
  OnInit,
  Renderer2,
} from "@angular/core";
import {MatRipple} from "@angular/material/core";
import {SharedAbstractDirective} from "@shared/directives/shared-abstract/shared-abstract.directive";
import {isNullOrUndefined} from "solidify-frontend";

@Directive({
  selector: "[dlcmRoundButton]",
  providers: [MatRipple],
})
export class SharedRoundButtonDirective extends SharedAbstractDirective implements OnInit {
  @Input("dlcmRoundButtonColor")
  private color: Color = Color.primary;

  constructor(protected readonly _elementRef: ElementRef,
              protected readonly _renderer: Renderer2,
              protected readonly _ripple: MatRipple) {
    super();
  }

  ngOnInit(): void {
    super.ngOnInit();
    if (!isNullOrUndefined(this.color)) {
      this._renderer.addClass(this._elementRef.nativeElement, this.color);
    }
    this._renderer.setAttribute(this._elementRef.nativeElement, "type", "button");
    this._renderer.setStyle(this._elementRef.nativeElement, "position", "relative");
    this._renderer.setStyle(this._elementRef.nativeElement, "overflow", "hidden");
    this._renderer.setStyle(this._elementRef.nativeElement, "border-radius", "50px");
    this._renderer.setStyle(this._elementRef.nativeElement, "padding", "10px");
    this._renderer.setStyle(this._elementRef.nativeElement, "border", "none");
    this._renderer.setStyle(this._elementRef.nativeElement, "cursor", "pointer");
    this._renderer.setStyle(this._elementRef.nativeElement, "box-shadow", "0px 2px 20px -1px rgba(0, 0, 0, 0.2), 0px 1px 1px 0px rgba(0, 0, 0, 0.14), 0px 1px 3px 0px rgba(0, 0, 0, 0.12)");
    this._renderer.setStyle(this._elementRef.nativeElement, "display", "flex");
    this._renderer.setStyle(this._elementRef.nativeElement, "align-items", "center");
    this._renderer.setStyle(this._elementRef.nativeElement, "justify-content", "center");
    this._renderer.setStyle(this._elementRef.nativeElement, "margin", "5px 0");
  }

  @HostListener("mousedown", ["$event"]) onmousedown(mouseEvent: MouseEvent): void {
    this._ripple.launch(mouseEvent.x, mouseEvent.y);
  }
}

type Color = "primary" | "accent" | "warn";
const Color = {
  primary: "primary" as Color,
  accent: "accent-units" as Color,
  warn: "access-levels" as Color,
};
