import {
  Directive,
  ElementRef,
  Input,
  OnInit,
  Renderer2,
} from "@angular/core";
import {SharedAbstractDirective} from "@shared/directives/shared-abstract/shared-abstract.directive";

@Directive({
  selector: "[dlcmMatButtonTheme]",
})
export class SharedMatButtonThemeDirective extends SharedAbstractDirective implements OnInit {

  static readonly themeClassNameMatPrefix: string = "mat-";

  static readonly defaultThemeClassName: MatButtonThemeClassName = "button";

  private static _themeClassNames: MatButtonThemeClassName[] = ["button", "flat-button", "icon-button", "raised-button", "stroked-button", "mini-fab", "fab"];

  static getThemeClassNames(addPrefix?: boolean): string[] {
    return addPrefix ? this._themeClassNames.map(themeClassName => this.themeClassNameMatPrefix + themeClassName) : this._themeClassNames.slice();
  }

  private _class: MatButtonThemeClassName = SharedMatButtonThemeDirective.defaultThemeClassName;

  @Input("dlcmMatButtonTheme")
  set class(value: MatButtonThemeClassName) {
    this._class = value || SharedMatButtonThemeDirective.defaultThemeClassName;
    this._onThemeClassNameChange();
  }

  get class(): MatButtonThemeClassName {
    return this._class;
  }

  constructor(protected readonly _elementRef: ElementRef,
              protected readonly _renderer: Renderer2) {
    super();
  }

  private _onThemeClassNameChange(): void {
    SharedMatButtonThemeDirective.getThemeClassNames(true)
      .forEach(themeClassNameToRemove => this._renderer.removeClass(this._elementRef.nativeElement, themeClassNameToRemove));
    this._renderer.addClass(this._elementRef.nativeElement, SharedMatButtonThemeDirective.themeClassNameMatPrefix + this._class);
  }

}

export type MatButtonThemeClassName = "button" | "flat-button" | "icon-button" | "raised-button" | "stroked-button" | "mini-fab" | "fab";
