import {
  Directive,
  ElementRef,
  Input,
  OnInit,
  Renderer2,
} from "@angular/core";
import {SharedAbstractDirective} from "@shared/directives/shared-abstract/shared-abstract.directive";
import {DataTestEnum} from "@shared/enums/data-test.enum";
import {dataTestAttributeName} from "@shared/shared.const";
import {isNullOrUndefined} from "solidify-frontend";

@Directive({
  selector: "[dlcmDataTest]",
})
export class SharedDataTestDirective extends SharedAbstractDirective implements OnInit {
  private _dataTest: DataTestEnum;

  @Input("dlcmDataTest")
  set dataTest(value: DataTestEnum) {
    this._dataTest = value;
    this._onDataTestChange();
  }

  get dataTest(): DataTestEnum {
    return this._dataTest;
  }

  constructor(protected readonly _elementRef: ElementRef,
              protected readonly _renderer: Renderer2) {
    super();
  }

  private _onDataTestChange(): void {
    if (isNullOrUndefined(this._dataTest)) {
      this._renderer.removeAttribute(this._elementRef.nativeElement, dataTestAttributeName);
    } else {
      this._renderer.setAttribute(this._elementRef.nativeElement, dataTestAttributeName, this._dataTest);
    }
  }

}
