import {
  ComponentFactoryResolver,
  Directive,
  ElementRef,
  Input,
  OnInit,
  Renderer2,
  ViewContainerRef,
} from "@angular/core";
import {environment} from "@environments/environment";
import {SharedAbstractSpinnerDirective} from "@shared/directives/shared-abstract-spinner/shared-abstract-spinner.directive";
import {
  isNullOrUndefined,
  isTrue,
} from "solidify-frontend";

@Directive({
  selector: "[dlcmButtonSpinner]",
})
export class SharedButtonSpinnerDirective extends SharedAbstractSpinnerDirective implements OnInit {

  @Input("dlcmButtonSpinner")
  set show(value: boolean) {
    if (isNullOrUndefined(value)) {
      console.warn("dlcmButtonSpinner directive received a null or undefined value");
      value = true;
    }
    this._show = value;
    if (!this._isReady) {
      return;
    }

    if (isTrue(this._show)) {
      if (!isNullOrUndefined(this.originalMatButtonWrapper)) {
        this._renderer.setStyle(this.originalMatButtonWrapper, "visibility", "hidden");
      }
      this._renderer.setStyle(this._elementRef.nativeElement, "pointer-events", "none");
      this._renderer.appendChild(this._elementRef.nativeElement, this.spinnerWrapper);
    } else {
      this._renderer.removeChild(this._elementRef.nativeElement, this.spinnerWrapper);
      this._renderer.setStyle(this.originalMatButtonWrapper, "visibility", "initial");
      this._renderer.setStyle(this._elementRef.nativeElement, "pointer-events", "initial");
    }

    if (isTrue(this.disableButton)) {
      this._elementRef.nativeElement.disabled = this._show;
    }
  }

  @Input("dlcmButtonSpinnerDisable")
  disableButton: boolean = false;

  @Input("dlcmButtonSpinnerStrokeWidth")
  strokeWidth: number = environment.defaultButtonSpinnerStrokeWidth;

  @Input("dlcmButtonSpinnerDiameter")
  diameter: number = environment.defaultButtonSpinnerDiameter;

  private originalMatButtonWrapper: HTMLSpanElement;

  constructor(protected readonly _elementRef: ElementRef,
              protected readonly _renderer: Renderer2,
              protected readonly _viewContainerRef: ViewContainerRef,
              protected readonly _componentFactoryResolver: ComponentFactoryResolver) {
    super(_elementRef, _renderer, _viewContainerRef, _componentFactoryResolver, "button-spinner-background");
  }

  ngOnInit(): void {
    super.ngOnInit();
    this.originalMatButtonWrapper = this._elementRef.nativeElement.querySelector(".mat-button-wrapper") as HTMLSpanElement;
  }
}
