import {
  Directive,
  ElementRef,
  HostListener,
  Input,
  OnInit,
  Renderer2,
} from "@angular/core";
import {MatRipple} from "@angular/material/core";
import {SharedAbstractDirective} from "@shared/directives/shared-abstract/shared-abstract.directive";
import {isNullOrUndefined} from "solidify-frontend";

@Directive({
  selector: "[dlcmAlternativeButton]",
  providers: [MatRipple],
})
export class SharedAlternativeButtonDirective extends SharedAbstractDirective implements OnInit {
  @Input("dlcmAlternativeButtonColor")
  color: "primary" | "accent" | "warn" = "primary";

  @Input("dlcmAlternativeButtonIcon")
  icon: boolean = false;

  constructor(protected readonly _elementRef: ElementRef,
              protected readonly _renderer: Renderer2,
              protected readonly _ripple: MatRipple) {
    super();
  }

  ngOnInit(): void {
    super.ngOnInit();
    if (!isNullOrUndefined(this.color)) {
      this._renderer.addClass(this._elementRef.nativeElement, this.color);
    }
    this._renderer.setAttribute(this._elementRef.nativeElement, "type", "button");
    this._renderer.setStyle(this._elementRef.nativeElement, "position", "relative");
    this._renderer.setStyle(this._elementRef.nativeElement, "overflow", "hidden");
    this._renderer.setStyle(this._elementRef.nativeElement, "border-radius", "50px");
    this._renderer.setStyle(this._elementRef.nativeElement, "border", "1px solid black");
    this._renderer.setStyle(this._elementRef.nativeElement, "padding", "10px");
    this._renderer.setStyle(this._elementRef.nativeElement, "background-color", "white");
    this._renderer.setStyle(this._elementRef.nativeElement, "cursor", "pointer");
    this._renderer.setStyle(this._elementRef.nativeElement, "display", "flex");
    this._renderer.setStyle(this._elementRef.nativeElement, "align-items", "center");
    this._renderer.setStyle(this._elementRef.nativeElement, "justify-content", "center");
    this._renderer.setStyle(this._elementRef.nativeElement, "margin", "5px 0");

    if (this.icon) {
      this._renderer.setStyle(this._elementRef.nativeElement, "margin", "5px 0");
      this._renderer.setStyle(this._elementRef.nativeElement, "display", "grid");
      this._renderer.setStyle(this._elementRef.nativeElement, "grid-template-columns", "minmax(20px, 75px) 1fr");
      this._renderer.setStyle(this._elementRef.nativeElement, "grid-gap", "10px");
    }
  }

  @HostListener("mousedown", ["$event"]) onmousedown(mouseEvent: MouseEvent): void {
    this._ripple.launch(mouseEvent.x, mouseEvent.y);
  }
}
