import {
  ComponentFactoryResolver,
  Directive,
  ElementRef,
  OnInit,
  Renderer2,
  ViewContainerRef,
} from "@angular/core";
import {MatSpinner} from "@angular/material/progress-spinner";
import {SharedAbstractDirective} from "@app/shared/directives/shared-abstract/shared-abstract.directive";
import {
  isNullOrUndefined,
  isTrue,
} from "solidify-frontend";

@Directive()
export abstract class SharedAbstractSpinnerDirective extends SharedAbstractDirective implements OnInit {
  protected _isReady: boolean;
  protected _show: boolean;
  spinnerWrapperAdditionalClass: string | undefined;

  abstract set show(value: boolean);

  abstract strokeWidth: number;

  abstract diameter: number;

  protected readonly spinnerWrapper: HTMLDivElement = this.createSpinnerWrapper();

  constructor(protected readonly _elementRef: ElementRef,
              protected readonly _renderer: Renderer2,
              protected readonly _viewContainerRef: ViewContainerRef,
              protected readonly _componentFactoryResolver: ComponentFactoryResolver,
              protected readonly _spinnerWrapperClass: string) {
    super();
  }

  ngOnInit(): void {
    super.ngOnInit();

    this._renderer.setStyle(this._elementRef.nativeElement, "position", "relative");

    const spinner = this.createSpinnerComponent();
    this._renderer.appendChild(this.spinnerWrapper, spinner._elementRef.nativeElement);
    this.addAdditionalClass();
    this._isReady = true;
    if (isTrue(this._show)) {
      this.show = this._show;
    }
  }

  protected addAdditionalClass(): void {
    if (!isNullOrUndefined(this.spinnerWrapperAdditionalClass)) {
      this._renderer.addClass(this.spinnerWrapper, this.spinnerWrapperAdditionalClass);
    }
  }

  protected createSpinnerWrapper(): HTMLDivElement {
    const spinnerWrapper = this._renderer.createElement("div");
    this._renderer.setStyle(spinnerWrapper, "display", "flex");
    this._renderer.setStyle(spinnerWrapper, "align-items", "center");
    this._renderer.setStyle(spinnerWrapper, "justify-content", "center");
    this._renderer.setStyle(spinnerWrapper, "position", "absolute");
    this._renderer.setStyle(spinnerWrapper, "left", "0");
    this._renderer.setStyle(spinnerWrapper, "right", "0");
    this._renderer.setStyle(spinnerWrapper, "top", "0");
    this._renderer.setStyle(spinnerWrapper, "width", "100%");
    this._renderer.setStyle(spinnerWrapper, "bottom", "0");
    this._renderer.setStyle(spinnerWrapper, "min-height", "0");
    this._renderer.addClass(spinnerWrapper, this._spinnerWrapperClass);
    return spinnerWrapper;
  }

  protected createSpinnerComponent(): MatSpinner {
    const factory = this._componentFactoryResolver.resolveComponentFactory(MatSpinner);
    const componentRef = this._viewContainerRef.createComponent(factory);
    const spinner = componentRef.instance;
    spinner.strokeWidth = this.strokeWidth;
    spinner.diameter = this.diameter;
    return spinner;
  }
}
