import {
  Directive,
  HostListener,
} from "@angular/core";
import {SharedAbstractRoutable} from "@shared/components/routables/shared-abstract/shared-abstract.routable";
import {ICanDeactivate} from "@shared/models/can-deactivate.model";

@Directive()
export abstract class CanDeactivateRoutable extends SharedAbstractRoutable implements ICanDeactivate {
  abstract canDeactivate(): boolean;

  @HostListener("window:beforeunload", ["$event"])
  leaveWithoutSaveNotification($event: Event): void {
    if (!this.canDeactivate()) {
      $event.returnValue = true;
    }
  }
}
